<?php
namespace controller;
use ControllerScheme;
use FwHtml\Elements\Tags\Main\HtmlTags;

class Regions extends ControllerScheme {
    const name = 'منطقه';

    public function getCities()
    {
        $state = $this->requestArray()['state_id'];
        $cities = \model\Cities::getAllFiltered('state_id',$state);
        $output =[HtmlTags::Option()->Selected()->Disabled()->Content('لطفا یک مورد را انتخاب کنید')];
        foreach ($cities as $city){
            $output[]=HtmlTags::Option()->Value($city->city_id)->Content($city->city_name);
        }
        return implode('.',$output);

    }

    public function getRegions()
    {
        $city = $this->requestArray()['id'];
        $regions = \model\Regions::getAllFiltered('city_id',$city);
        $output =[HtmlTags::Option()->Selected()->Disabled()->Content('لطفا یک مورد را انتخاب کنید')];
        foreach ($regions as $region){
            $output[]=HtmlTags::Option()->Value($region->region_id)->Content($region->region_name);
        }
        return implode('.',$output);

    }
    
}