<?php

namespace controller;

use ControllerScheme;
use model\Entity\ProviderGalleriesEntity;

class Providers extends ControllerScheme
{
    const name = 'پذیرنده';

    public static $__uploads = ["provider_logo" => __SOURCE__ . "images/Providers/"];

    protected function add(?bool $csrf = true)
    {

        $checkbox = $this->requestArray('time_data');
        $dayInfos = $checkbox['dayInfo'];
        $checkbox = $checkbox['checkbox'];
        $output = [];
        if (is_iterable($checkbox)) {
            foreach ($checkbox as $dayName => $shifts) {
                foreach ($shifts as $shift) {
                    if (isset($dayInfos[$dayName]) and isset($dayInfos[$dayName][$shift])) {
                        if (!isset($output[$dayName])) {
                            $output[$dayName] = [];
                        }
                        $output[$dayName][$shift] = [
                            'start' => $dayInfos[$dayName][$shift]['start'],
                            'end' => $dayInfos[$dayName][$shift]['end'],
                        ];
                    }
                }
            }
        }

        $attributes = $this->requestArray()['attributes'] ?? [];

        $attributeIds = [];
        if (is_array($attributes)) {
            foreach ($attributes as $attribute) {
                $name = $attribute['name'] ?? "";
                $value = $attribute["value"] ?? "";
                if ($name !== '' && $value !== '') {
                    $attributeId = \model\Attributes::add([
                        'attribute_name' => $name,
                        'attribute_value' => $value,
                    ]);
                    $attributeIds[] = $attributeId;
                }
            }
        }
        $req = $this->requestArray();
        unset($req['time_data']);
        $req['provider_work_hours'] = $output;
        unset($req['attributes']);
        $req['attribute_ids'] = $attributeIds;
        $this->setRequestArray($req);

        $res = parent::add($csrf);
        $provider_id = \model\Providers::LastId();

        $gallery_images = $_FILES['gallery_images'] ?? null;

        if ($gallery_images && is_array($gallery_images['name'])) {
            foreach ($gallery_images['name'] as $index => $imageName) {
                $tmpName = $gallery_images['tmp_name'][$index]['file'];
                $error = $gallery_images['error'][$index]['file'];

                if ($error === UPLOAD_ERR_OK) {
                    $extension = pathinfo($imageName['file'], PATHINFO_EXTENSION);
                    $unique = (int)(microtime(true) * 1000);
                    $newFileName = 'provider_image' . $unique . '.' . $extension;
                    $destinationPath = __SOURCE__ . "images/ProviderGalleries/" . $newFileName;

                    if (move_uploaded_file($tmpName, $destinationPath)) {
                        \model\ProviderGalleries::add([
                            'provider_id' => $provider_id,
                            'provider_image' => $newFileName,
                        ]);
                    }
                }
            }
        }


        return $res;
    }

    public function edit()
    {
        $checkbox = $this->requestArray('time_data');
        $dayInfos = $checkbox['dayInfo'];
        $checkbox = $checkbox['checkbox'];
        $output = [];
        if (is_iterable($checkbox)) {
            foreach ($checkbox as $dayName => $shifts) {
                foreach ($shifts as $shift) {
                    if (isset($dayInfos[$dayName]) and isset($dayInfos[$dayName][$shift])) {
                        if (!isset($output[$dayName])) {
                            $output[$dayName] = [];
                        }
                        $output[$dayName][$shift] = [
                            'start' => $dayInfos[$dayName][$shift]['start'],
                            'end' => $dayInfos[$dayName][$shift]['end'],
                        ];
                    }
                }
            }
        }

        $req = $this->requestArray();


        $provider_id = $req['provider_id'] ?? null;
        if ($provider_id) {
            $provider = \model\Providers::get($provider_id);
            $oldAttributeIds = json_decode($provider->attribute_ids, true);
            if (is_array($oldAttributeIds)) {
                foreach ($oldAttributeIds as $attrId) {
                    \model\Attributes::delete($attrId);
                }
            }
        }

        $attributes = $req['attributes'] ?? [];
        $attributeIds = [];
        if (is_array($attributes)) {
            foreach ($attributes as $attribute) {
                $name = $attribute['name'] ?? "";
                $value = $attribute["value"] ?? "";
                if ($name !== '' && $value !== '') {
                    $attributeId = \model\Attributes::add([
                        'attribute_name' => $name,
                        'attribute_value' => $value,
                    ]);
                    $attributeIds[] = $attributeId;
                }
            }
        }




        $gallery_images_post = $req['gallery_images'] ?? [];
        $existingUrls = array_values(array_filter(array_map(function($item) {
            return $item['url'] ?? null; 
        }, $gallery_images_post)));
        $currentGalleries = \model\ProviderGalleries::Db()->where('provider_id', $provider_id)->get();

        foreach ($currentGalleries as $gallery) {
            if (!in_array($gallery->provider_image, $existingUrls)) {
                $imagePath = __SOURCE__ . "images/ProviderGalleries/" . $gallery->provider_image;
                if (file_exists($imagePath)) {
                    unlink($imagePath);
                }
                \model\ProviderGalleries::delete($gallery->provider_gallery_id);
            }
        }

        $gallery_images = $_FILES['gallery_images'] ?? null;

        if ($gallery_images && is_array($gallery_images['name'])) {
            foreach ($gallery_images['name'] as $index => $imageName) {
                $tmpName = $gallery_images['tmp_name'][$index]['file'];
                $error = $gallery_images['error'][$index]['file'];

                if ($error === UPLOAD_ERR_OK) {
                    $extension = pathinfo($imageName['file'], PATHINFO_EXTENSION);
                    $unique = (int)(microtime(true) * 1000);
                    $newFileName = 'provider_image' . $unique . '.' . $extension;
                    $destinationPath = __SOURCE__ . "images/ProviderGalleries/" . $newFileName;

                    if (move_uploaded_file($tmpName, $destinationPath)) {
                        \model\ProviderGalleries::add([
                            'provider_id' => $provider_id,
                            'provider_image' => $newFileName,
                        ]);
                    }
                }
            }
        }


        unset($req['time_data']);
        $req['provider_work_hours'] = $output;
        unset($req['attributes']);
        $req['attribute_ids'] = $attributeIds;
        unset($req['gallery_images']);

        $this->setRequestArray($req);
        return parent::edit();
    }

}