import VariableDeclaration from './VariableDeclaration';
import ExecutionPathOptions from '../ExecutionPathOptions';
import Scope from '../scopes/Scope';
import { StatementBase, StatementNode } from './shared/Statement';
import { NodeType } from './index';
import { ExpressionNode } from './shared/Node';
export default class ForStatement extends StatementBase {
    type: NodeType.ForStatement;
    init: VariableDeclaration | ExpressionNode | null;
    test: ExpressionNode | null;
    update: ExpressionNode | null;
    body: StatementNode;
    hasEffects(options: ExecutionPathOptions): boolean;
    initialiseChildren(): void;
    initialiseScope(parentScope: Scope): void;
}
