import CallOptions from '../CallOptions';
import ExecutionPathOptions from '../ExecutionPathOptions';
import { ObjectPath } from '../variables/VariableReassignmentTracker';
import { ForEachReturnExpressionCallback, PredicateFunction, SomeReturnExpressionCallback } from './shared/Expression';
import { NodeType } from './index';
import { ExpressionNode, NodeBase } from './shared/Node';
export declare type LogicalOperator = '||' | '&&';
export default class LogicalExpression extends NodeBase {
    type: NodeType.LogicalExpression;
    operator: LogicalOperator;
    left: ExpressionNode;
    right: ExpressionNode;
    reassignPath(path: ObjectPath, options: ExecutionPathOptions): void;
    forEachReturnExpressionWhenCalledAtPath(path: ObjectPath, callOptions: CallOptions, callback: ForEachReturnExpressionCallback, options: ExecutionPathOptions): void;
    getValue(): any;
    hasEffects(options: ExecutionPathOptions): boolean;
    hasEffectsWhenAccessedAtPath(path: ObjectPath, options: ExecutionPathOptions): boolean;
    hasEffectsWhenAssignedAtPath(path: ObjectPath, options: ExecutionPathOptions): boolean;
    hasEffectsWhenCalledAtPath(path: ObjectPath, callOptions: CallOptions, options: ExecutionPathOptions): boolean;
    someReturnExpressionWhenCalledAtPath(path: ObjectPath, callOptions: CallOptions, predicateFunction: SomeReturnExpressionCallback, options: ExecutionPathOptions): boolean;
    _forEachRelevantBranch(callback: (node: ExpressionNode) => void): void;
    _someRelevantBranch(predicateFunction: PredicateFunction): boolean;
}
