<?php

namespace model\Entity;

use DATABASE\ORM\Interact\Entities\EntityScheme;

class RegionsEntity extends EntityScheme {
    public $region_id;
    /**
     * نام منطقه
     **/
    public $name;
    /**
     * انتخاب استان
     **/
    public $state_id;
    /**
     * انتخاب شهر
     **/
    public $city_id;

    public function model() {
        return new \model\Regions();
    }


    protected function dictionary(): array {
        return [
            'region_id' => 'region_id', 'name' => 'region_name', 'state_id' => 'state_id', 'city_id' => 'city_id',
        ];
    }

    public function apiFormat() {
        return [
            'id'   => $this->region_id,
            'name' => $this->name,
        ];
    }

}
