<?php

namespace model\Entity;

use DATABASE\ORM\Interact\Entities\EntityScheme;
use model\Cities;

class StatesEntity extends EntityScheme {
    public $state_id;
    /**
     * نام استان
     **/
    public $name;

    public function model() {
        return new \model\States();
    }


    protected function dictionary(): array {
        return [
            'state_id' => 'state_id', 'name' => 'state_name',
        ];
    }

    public function apiFormat(): array {
        return [
            'id'        => $this->state_id,
            'name'      => $this->name,
            'cityCount' => Cities::Db()->where('state_id', $this->state_id)->rowCount(),
        ];
    }

}
