<?php

namespace model\Entity;

use DATABASE\ORM\Interact\Entities\EntityScheme;

class HomeSectionEntity extends EntityScheme
{
    public $home_section_id;

    public $top_title;
    public $top_description;
    public $providers_count;
    public $users_count;

    public $bottom_title;
    public $bottom_image;
    public $bottom_text;
    public $button_text;
    public $button_icon;
    public $button_link;


    public function model()
    {
        return new \model\HomeSection();
    }

    public function apiFormat()
    {
        $providersCount = \model\Providers::Db()->rowCount() + $this->providers_count;
        $usersCount = \model\Users::Db()->rowCount() + $this->users_count;
        return [
            'topTitle' => $this->top_title,
            'topDescription' => $this->top_description,
            'providersCount' => $providersCount,
            'usersCount' => $usersCount,
            'bottomTitle' => $this->bottom_title,
            'bottomImage' => __IMAGES__ . 'HomeSection/' . $this->bottom_image,
            'bottomText' => $this->bottom_text,
            'buttonText' => $this->button_text,
            'buttonIcon' => __IMAGES__ . 'HomeSection/' .$this->button_icon,
            'buttonLink' => $this->button_link
        ];
    }

}
