<?php

namespace model\Entity;

use DATABASE\ORM\Interact\Entities\EntityScheme;

class SocialsEntity extends EntityScheme
{
    public $social_id;
    /**
     * نام شبکه
     **/
    public $name;
    /**
     * لینک
     **/
    public $link;
    /**
     * آیکون
     **/
    public $icon;

    public function model()
    {
        return new \model\Socials();
    }

    public function icon(): string
    {
        return __IMAGES__ . "Socials/" . $this->icon;
    }

    public function apiFormat()
    {
        return [
            'id' => $this->social_id,
            'name' => $this->name,
            'link' => $this->link,
            'icon' => $this->icon()
        ];
    }

    protected function dictionary(): array
    {
        return [
            'social_id' => 'social_id',
            'name' => 'social_name',
            'link' => 'social_link',
            'icon' => 'social_icon',
        ];
    }
}
