<?php

namespace FwMigrationSystem\User;

use FwMigrationSystem\Main\Migratable;
use FwMigrationSystem\Main\Migration;
use FwMigrationSystem\Resources\Blueprint;
use FwMigrationSystem\Resources\TableName;

class LotteriesMigration extends Migratable {
    const modelName = 'Lotteries';

    public function create_table() {
        return Migration::Create(new TableName(self::modelName), function (Blueprint $blueprint) {
            $blueprint->primary_key('lottery_id');
			$blueprint->VarChar('lottery_name')->Len(150);
			$blueprint->Int('course_id')->Len(150);
			$blueprint->Int('lottery_from_date')->Len(150);
			$blueprint->Int('lottery_to_date')->Len(150);
			$blueprint->Int('lottery_max_winners')->Len(150);
			$blueprint->Int('lottery_status')->Len(150);
			$blueprint->Datetime('created_at')->Default('CURRENT_TIMESTAMP()');

             return $blueprint;
        });
    }

    public function drop_table() {
        return Migration::DropIfExists(new TableName(self::modelName));
    }
}
