<?php

namespace FwMigrationSystem\User;

use FwMigrationSystem\Main\Migratable;
use FwMigrationSystem\Main\Migration;
use FwMigrationSystem\Resources\Blueprint;
use FwMigrationSystem\Resources\TableName;

class PlansMigration extends Migratable {
    const modelName = 'Plans';

    public function create_table() {
        return Migration::Create(new TableName(self::modelName), function (Blueprint $blueprint) {
            $blueprint->primary_key('plan_id');
			$blueprint->VarChar('plan_name')->Len(150);
			$blueprint->VarChar('plan_icon')->Len(150);
			$blueprint->VarChar('plan_price')->Len(150);
			$blueprint->VarChar('plan_duration')->Len(150);
			$blueprint->Text('plan_description');
			$blueprint->Datetime('created_at')->Default('CURRENT_TIMESTAMP()');

             return $blueprint;
        });
    }

    public function drop_table() {
        return Migration::DropIfExists(new TableName(self::modelName));
    }
}
