<?php

namespace FwMigrationSystem\User;

use FwMigrationSystem\Main\Migratable;
use FwMigrationSystem\Main\Migration;
use FwMigrationSystem\Resources\Blueprint;
use FwMigrationSystem\Resources\TableName;

class UsersMigration extends Migratable {
    const modelName = 'Users';

    public function create_table() {
        return Migration::Create(new TableName(self::modelName), function (Blueprint $blueprint) {
            $blueprint->primary_key('user_id');
			$blueprint->VarChar('user_name')->Len(150);
			$blueprint->VarChar('user_mobile')->Len(150);
			$blueprint->VarChar('user_password')->Len(150);
			$blueprint->Int('plan_id')->Len(150);
			$blueprint->VarChar('plan_activated_at')->Len(150);
			$blueprint->VarChar('plan_expired_at')->Len(150);
			$blueprint->VarChar('user_plan_code')->Len(150);
			$blueprint->Datetime('created_at')->Default('CURRENT_TIMESTAMP()');

             return $blueprint;
        });
    }

    public function drop_table() {
        return Migration::DropIfExists(new TableName(self::modelName));
    }
}
