<?php

namespace FwMigrationSystem\User;

use FwMigrationSystem\Main\Migratable;
use FwMigrationSystem\Main\Migration;
use FwMigrationSystem\Resources\Blueprint;
use FwMigrationSystem\Resources\TableName;

class WelcomePageMigration extends Migratable {
    const modelName = 'WelcomePage';

    public function create_table() {
        return Migration::Create(new TableName(self::modelName), function (Blueprint $blueprint) {
            $blueprint->primary_key('welcome_pag_id');
			$blueprint->VarChar('welcome_title')->Len(150);
			$blueprint->VarChar('welcome_des')->Len(150);
			$blueprint->VarChar('welcome_right_image')->Len(150);
			$blueprint->VarChar('welcome_left_image')->Len(150);
			$blueprint->Datetime('created_at')->Default('CURRENT_TIMESTAMP()');

             return $blueprint;
        });
    }

    public function drop_table() {
        return Migration::DropIfExists(new TableName(self::modelName));
    }
}
