<?php

namespace model;

use DATABASE\Model;
use model\Entity\ScoresEntity;
use model\Entity\UsersEntity;

class Points extends Model {
	public $_table = 'tblPoints';
	public $_key = 'point_id';
	public $_Entity = \model\Entity\PointsEntity::class;

	public static function award(UsersEntity $user, ScoresEntity $score, string $info = "", int $multipier = 1): bool {
		$points = ($score->point * $multipier);
		$update = Users::edit($user->user_id, [
			'user_score' => $user->score + $points,
		]);
		$cause = $score->name;
		if ($score->score_id == 8) {
			$cause = str($cause)->replace("(هر ماه)", "");
		}
		Notifications::send("دریافت امتیاز", "$points امتیاز بابت $cause به امتیازات شما افزوده شد!.", $user, Files::get(12), '/club');
		return $update && Points::add([
				'user_id'     => $user->user_id,
				'point_score' => $points,
				'point_cause' => $cause . $info,
			]);
	}

	public static function buy(?UsersEntity $user, Entity\RewardsEntity $reward): bool {
		$points = $reward->required_points;
		$update = Users::edit($user->user_id, [
			'user_score' => $user->score - $points,
		]);
		$cause = $reward->name;
		Notifications::send("استفاده از امتیاز", "$points امتیاز بابت $cause به از امتیاز شما کسر شد!.", $user);
		return $update && Points::add([
				'user_id'     => $user->user_id,
				'point_score' => -$points,
				'point_cause' => $cause,
			]);
	}

}