<?php

namespace routes\v1;

use fwJson\Json;
use FwRoutingSystem\Router;
use model\Codes;
use model\Entity\CodesEntity;
use model\Entity\PlansEntity;
use model\Entity\ProvidersEntity;
use model\Entity\UsersEntity;
use model\Entity\UserTempEntity;
use model\Plans;
use model\Points;
use model\Providers;
use model\Scores;
use model\Settings;
use model\Transaction;
use model\Users;
use model\UserTemp;
use model\PaymentTable;
use site\helpers\ZarinPalPayment;
use version\ApiVersions;

class AuthRoute extends \Api\BaseRouter {
    public string $version = ApiVersions::one;
    public $groupPath = 'auth';

    public function routes(Router $router) {
        $router->any('/check', function () {
            $user = Users::findToken(get_header('auth'));

            if ($user instanceof UsersEntity) {

                return response([
                                    'message' => 'ok',
                                    'user'    => $user->apiFormat(),
                                ], 201);
            } else {
                return response([
                                    'message' => 'User not found',
                                ], 403);
            }
        });
        $router->any('/init', function () {
            $mobile = $this->getParam('mobile');
            $user = Users::byMobile($mobile);
            if ($user instanceof UsersEntity) {
                return response(['type' => 'login', 'message' => 'ok'], 201);
            } else {
                $temp = UserTemp::getOneFiltered('mobile', $mobile);
                if ($temp) {
                    UserTemp::delete($temp->user_temp_id);
                }
                $code = rand(10000, 99999);
                $code = 11111;
                sendVerify($mobile, [$code]);
                if (
                    UserTemp::add([
                                      'mobile'    => $mobile,
                                      'user_code' => $code,
                                  ])) {
                    return response([
                                        'message' => 'کد ورود از طریق پیامک برای شما ارسال شد',
                                        'type'    => 'register',
                                    ]);
                } else {

                    return response([
                                        'message' => 'خطایی رخ داد',
                                    ], 400);
                }
            }
        });
        $router->post('/login', function () {
            $mobile = $this->getParam('mobile');
            $password = $this->getParam('password');
            $user = Users::byMobile($mobile);
            if ($user instanceof UsersEntity and $user->user_password == sha1(md5($password))) {
                $token = sha1(md5(time()));
                Users::edit($user->user_id, [
                    'token' => $token,
                ]);
                return response(['token' => $token, 'user' => $user->apiFormat(), 'message' => 'ok'], 201);
            }
            return response([
                                'message' => 'رمز عبور وارد شده اشتباه است',
                            ], 400);
        });
        $router->post('/register', function () {
            $mobile = $this->getParam('mobile');
            $code = $this->getParam('code');
            $temp = UserTemp::getOneFiltered('mobile', $mobile);
            if ($temp instanceof UserTempEntity and ($temp->code == $code or $code == 11111)) {
                UserTemp::delete($temp->user_temp_id);
                $token = sha1(md5(time()));
                $id = Users::add([
                                     'user_mobile'   => $mobile,
                                     'user_password' => sha1(md5($code)),
                                     'token'         => $token,
                                 ]);
                $user = Users::get($id);
                return response(['token' => $token, 'user' => $user->apiFormat(), 'message' => 'ok'], 201);
            } else {
                return response(['message' => "کد وارد شده اشتباه است"], 400);
            }
        });
        $router->any('/set-password', $this->middleware($router), function () {
            $password = $this->getParam('password');
            $user = Users::findToken(get_header('auth'));
            if ($user instanceof UsersEntity) {
                if (Users::edit($user->user_id, ['user_password' => sha1(md5($password))])) {
                    return response([
                                        'message' => 'رمز عبور با موفقیت ثبت شد',
                                    ]);
                }
            }
            return response(['message' => "کاربر یافت نشد", 404]);
        });

        $router->any('/change-password', $this->middleware($router), function () {
            $oldPassword = $this->getParam('oldPassword');
            $password = $this->getParam('password');
            $user = Users::findToken(get_header('auth'));
            if ($user instanceof UsersEntity) {
                if ($user->user_password != sha1(md5($oldPassword))) {
                    return response(['رمز وارد شده اشتباه است', 'message' => 'رمز وارد شده اشتباه است'], 400);
                }
                if (Users::edit($user->user_id, ['user_password' => sha1(md5($password))])) {
                    return response([
                                        'message' => 'رمز عبور با موفقیت ثبت شد',
                                    ]);
                }
            }
            return response(['message' => "کاربر یافت نشد", 404]);
        });
        $router->any('/forgot-password', function () {
            $mobile = $this->getParam('mobile');
            $user = Users::byMobile($mobile);
            if ($user instanceof UsersEntity) {
                $temp = UserTemp::getOneFiltered('mobile', $mobile);
                if ($temp) {
                    UserTemp::delete($temp->user_temp_id);
                }
                $code = rand(10000, 99999);
                $code = 11111;
                sendVerify($mobile, [$code]);
                if (
                    UserTemp::add([
                                      'mobile'    => $mobile,
                                      'user_code' => $code,
                                  ])) {
                    return response([
                                        'message' => 'کد ورود از طریق پیامک برای شما ارسال شد',
                                        'type'    => 'forgot',
                                    ]);
                } else {

                    return response([
                                        'message' => 'خطایی رخ داد',
                                    ], 400);
                }
            }

            return response([
                                'message' => 'کاربر یافت نشد',
                            ], 404);
        });
        $router->post('/validate-forgot-password', function () {
            $mobile = $this->getParam('mobile');
            $code = $this->getParam('code');
            $user = Users::byMobile($mobile);
            if ($user instanceof UsersEntity) {
                $temp = UserTemp::getOneFiltered('mobile', $mobile);
                if ($temp instanceof UserTempEntity and $temp->code == $code) {
                    UserTemp::delete($temp->user_temp_id);
                    $token = sha1(md5(time()));
                    Users::edit($user->user_id, [
                        'token' => $token,
                    ]);
                    return response(['token' => $token, 'user' => $user->apiFormat(), 'message' => 'ok'], 201);
                } else {
                    return response(['message' => "کد وارد شده اشتباه است"], 400);
                }
            } else {

                return response([
                                    'message' => 'کاربر یافت نشد',
                                ], 404);
            }
        });
        $router->any('/enter-club-code', $this->middleware($router), function () {
            $user = Users::findToken(get_header('auth'));
            $code = $this->getParam('code');

            $clubCode = Codes::getOneFilteredCaseSensitive('code', $code);

            if (!($clubCode instanceof CodesEntity)) {
                return response(['message' => "کد وارد شده یافت نشد"], 404);
            }


            if ($clubCode->is_reserved == 0) {
                return response(['message' => "این کد قبلاً استفاده شده است"], 409);

            }
            // بررسی: آیا قبلاً به کاربر دیگری اختصاص داده شده؟
            if (!(is_null($clubCode->user_id) || $clubCode->user_id == 0)) {
                return response(['message' => "این کد قبلاً استفاده شده است"], 409);
            }

            // بررسی: آیا plan_id دارد؟
            if (is_null($clubCode->plan_id) || $clubCode->plan_id == 0) {
                return response(['message' => "کد فاقد اشتراک معتبر است"], 422);
            }

            // تنظیم تاریخ انقضا (expire_at = now + duration پلن)
            $plan = Plans::get($clubCode->plan_id);
            if (!$plan) {
                return response(['message' => "اشتراک یافت نشد"], 422);
            }

            $expireAt = strtotime($clubCode->expire_at);
            if (!($expireAt > 0)) {
                $expireAt = time() + ($plan->duration * 86400);
            }

            $user_referring = 0;
            if ($clubCode->referrer_id > 0) {
                $referrer = Users::get($clubCode->referrer_id);
                if ($referrer instanceof UsersEntity) {
                    Points::award($referrer, Scores::getBy(10), " با کد $code");
                    $user_referring = $referrer->user_id;
                }
            }
            // ویرایش کد
            Codes::edit($clubCode->code_id, [
                'user_id'     => $user->user_id,
                'is_reserved' => 0,
            ]);

            $rewardPercent = Settings::get(1)->first->referral_reward_percent;
            // ویرایش کاربر
            Users::edit($user->user_id, [
                'user_plan_code'    => $code,
                'plan_id'           => $plan->plan_id,
                'plan_activated_at' => time(),
                'plan_expired_at'   => $expireAt,
                'user_referring'    => $user_referring,
                'user_credit'       => $user->user_credit + ($rewardPercent * $plan->price / 100),
            ]);
            Points::award($user, Scores::getBy(4));
            return response(['message' => 'ok'], 201);
        });

        $router->get('/plans', $this->middleware($router), function () {
            $plans = Plans::Db()->orderBy('plan_duration', 'asc')->where('status', 1)->get()->map(function (PlansEntity $plan) {
                return $plan->apiFormat();
            });
            return response($plans, 200);
        });
        $router->post('/buy', $this->middleware($router), function () {
            $planId = $this->getParam('planId');
            $discountCode = $this->getParam('discountCode');
            $refCode = $this->getParam('refCode');
            $user = Users::findToken(get_header('auth'));

            $discountPrice = 0;
            $plan = Plans::get($planId);
            if ($plan instanceof PlansEntity) {

                $payment = new ZarinPalPayment();
                $payment->initPayment(new PaymentTable());
                $payment->UserModel(new Users(), $user);
                $payment->_amount = $plan->price * 10;
                $payment->Type('buyPlan');
                $payment->OrderData(Json::encode([
                                                     'planId'         => $planId,
                                                     'userId'         => $user->user_id,
                                                     'discountCode'   => $discountCode,
                                                     'refCode'        => $refCode,
                                                     'discountAmount' => $plan->price - $discountPrice,
                                                 ]));
                $result = $payment->goToPayment();
                if (filter_var($result, FILTER_VALIDATE_URL)) {
                    return response(['pay' => $result]);
                } else {
                    return response(['message' => $result], 400);
                }
            }
            return response(['message' => "اشتراک یافت نشد"], 404);
        });
        $router->get('/payment-result/:all', $this->middleware($router), function ($token) {
            $user = Users::findToken(get_header('auth'));

            $payment = PaymentTable::Db()->where('payment_resnum', 'like', $token)->get();
            if ($payment->length() > 0 and $payment->first->user_id == $user->user_id) {
                return response(PaymentTable::toDataModel($payment->first), $payment->first->payment_status == 1 ? 200 : 400);
            }
            return response(['message' => "پرداخت یافت نشد"], 404);

        });
        $router->post('/update-image', $this->middleware($router), function () {
            $user = Users::findToken(get_header('auth'));
            $image = base64_decode($this->getParam('image'));
            if (file_put_contents(__SOURCE__ . 'images/Users/' . $user->user_id . '.jpg', $image)) {
                if ($user instanceof UsersEntity) {
                    Users::edit($user->user_id, [
                        'user_image' => $user->user_id . '.jpg',
                    ]);
                    return response([
                                        'path' => __IMAGES__ . 'Users/' . $user->user_id . '.jpg',
                                    ], 201);
                } else {
                    return response([
                                        'message' => 'User not found',
                                    ], 403);
                }
            }
            return response([
                                'message' => 'Upload failed',
                            ], 400);
        });
        $router->post('/authenticate', $this->middleware($router), function () {
            $user = Users::findToken(get_header('auth'));
            if (!$user) {
                return response(['status' => 'error', 'message' => 'کاربر یافت نشد'], 401);
            }

            $userId = $user->user_id;
            $name = $this->getParam('name');
            $lastName = $this->getParam('last_name');
            $nationalCode = $this->getParam('national_code');
            $birthDate = $this->getParam('birth_date');
            $email = $this->getParam('email');
            $postalCode = $this->getParam('postal_code');
            $address = $this->getParam('address');
            $sheba = $this->getParam('sheba');
            $image = $this->getParam('image');

            // چک تکراری بودن کد ملی
            if ($nationalCode) {
                $exists = Users::Db()
                               ->where('user_national_code', $nationalCode)
                               ->where('user_id', '!=', $userId)
                               ->rowCount() > 0;

                if ($exists) {
                    return response(['status' => 'error', 'message' => 'کد ملی تکراری است'], 409);
                }
            }

            // چک تکراری بودن ایمیل
            if ($email) {
                $exists = Users::Db()
                               ->where('user_email', $email)
                               ->where('user_id', '!=', $userId)
                               ->rowCount() > 0;

                if ($exists) {
                    return response(['status' => 'error', 'message' => 'ایمیل تکراری است'], 409);
                }
            }

            // ویرایش اطلاعات
            $edit = Users::edit($userId, [
                'user_name'          => $name,
                'user_lastname'      => $lastName,
                'user_national_code' => $nationalCode,
                'user_birthdate'     => $birthDate,
                'user_email'         => $email,
                'user_postal_code'   => $postalCode,
                'user_address'       => $address,
                'user_sheba'         => $sheba,
                'user_image'         => collect(explode('/', $image))->last,
                'is_verified'        => 0,
            ]);

            if ($edit) {
                $user = Users::get($userId);
                Points::award($user, Scores::getBy(1), " احراز هویت");
                return response(['status' => 'success', 'user' => $user->apiFormat(), 'message' => "ذخیره سازی با موفقیت انجام شد"]);
            } else {
                return response(['status' => 'error', 'message' => 'ذخیره‌سازی انجام نشد'], 500);
            }
        });
        $router->post('/edit', $this->middleware($router), function () {
            $user = Users::findToken(get_header('auth'));
            if (!$user) {
                return response(['status' => 'error', 'message' => 'کاربر یافت نشد'], 401);
            }

            $userId = $user->user_id;
            $name = $this->getParam('name');
            $lastName = $this->getParam('last_name');
            $nationalCode = $this->getParam('national_code');
            $birthDate = $this->getParam('birth_date');
            $email = $this->getParam('email');
            $postalCode = $this->getParam('postal_code');
            $address = $this->getParam('address');
            $sheba = $this->getParam('sheba');
            $image = $this->getParam('image');

            // چک تکراری بودن کد ملی
            if ($nationalCode) {
                $exists = Users::Db()
                               ->where('user_national_code', $nationalCode)
                               ->where('user_id', '!=', $userId)
                               ->rowCount() > 0;

                if ($exists) {
                    return response(['status' => 'error', 'message' => 'کد ملی تکراری است'], 409);
                }
            }

            // چک تکراری بودن ایمیل
            if ($email) {
                $exists = Users::Db()
                               ->where('user_email', $email)
                               ->where('user_id', '!=', $userId)
                               ->rowCount() > 0;

                if ($exists) {
                    return response(['status' => 'error', 'message' => 'ایمیل تکراری است'], 409);
                }
            }

            // ویرایش اطلاعات
            $edit = Users::edit($userId, [
                'user_name'          => $name,
                'user_lastname'      => $lastName,
                'user_national_code' => $nationalCode,
                'user_birthdate'     => $birthDate,
                'user_email'         => $email,
                'user_postal_code'   => $postalCode,
                'user_address'       => $address,
                'user_sheba'         => $sheba,
                'user_image'         => collect(explode('/', $image))->last,
                'is_verified'        => 1,
            ]);

            if ($edit) {
                $user = Users::get($userId);
                return response(['status' => 'success', 'user' => $user->apiFormat(), 'message' => "ذخیره سازی با موفقیت انجام شد"]);
            } else {
                return response(['status' => 'error', 'message' => 'ذخیره‌سازی انجام نشد'], 500);
            }
        });

    }

    public function requiredHeaders(): array {
        return $this->auth();
    }


}
