<?php

namespace routes\v1;

use FwRoutingSystem\Router;
use model\AboutUs;
use model\AppAboutUs;
use model\Comments;
use model\ContactUs;
use model\Entity\AboutUsEntity;
use model\Entity\AppAboutUsEntity;
use model\Entity\CommentsEntity;
use model\Entity\ContactUsEntity;
use model\Entity\RulesEntity;
use model\Entity\SettingsEntity;
use model\Entity\TicketCategoriesEntity;
use model\Entity\TicketsEntity;
use model\Entity\TransactionEntity;
use model\Entity\UserRewardsEntity;
use model\Entity\UsersEntity;
use model\Providers;
use model\Rules;
use model\Settings;
use model\TicketCategories;
use model\Tickets;
use model\Transaction;
use model\UserRewards;
use model\Users;
use version\ApiVersions;

class PagesRoute extends \Api\BaseRouter {
    public string $version = ApiVersions::one;
    public $groupPath = 'pages';

    public function routes(Router $router) {
        $router->any('/transactions', $this->middleware($router), function () {
            $user = Users::findToken(get_header('auth'));
            $transactions = Transaction::Db()->where('user_id', $user->user_id)->orderBy('created_at', true)->get()->map(function (TransactionEntity $transaction) {
                return $transaction->userApiFormat();
            });
            return response($transactions, 201);
        });
        $router->any('/comments', $this->middleware($router), function () {
            $user = Users::findToken(get_header('auth'));
            $comments = Comments::Db()->where('user_id', $user->user_id)->where('status', 1)->get()->map(function (CommentsEntity $comments) {
                return $comments->userApiFormat();
            });
            return response($comments, 201);
        });
        $router->group('/ticket', function (Router $router) {
            $router->get('/list', $this->middleware($router), function () {
                $user = Users::findToken(get_header('auth'));
                $comments = Tickets::Db()->where('user_id', $user->user_id)->where('parent_id', 0)->orderBy('created_at', true)->get()->map(function (TicketsEntity $comments) {
                    return $comments->apiFormat();
                });
                /** @var SettingsEntity $setting */
                $setting = Settings::get(1);
                return response(['tickets' => $comments, 'support' => "tel:" . $setting->tel], 201);
            });
            $router->any('/ticket/:id', $this->middleware($router), function ($id) {
                $user = Users::findToken(get_header('auth'));
                $comments = Tickets::Db()->where('parent_id', $id)->orderBy('created_at', true)->get()->map(function (TicketsEntity $ticket) {
                    return $ticket->apiFormat();
                });
                return response($comments, 201);
            });
            $router->any('/categories', function () {
                return response(TicketCategories::Db()->get()->map(function (TicketCategoriesEntity $ticketCategories) {
                    return $ticketCategories->apiFormat();
                })->values());
            });
            $router->post('/answer', $this->middleware($router), function () {
                $user = Users::findToken(get_header('auth'));
                $ticket = Tickets::get($this->getParam('id'));
                $text = $this->getParam('text');
                if (
                    Tickets::add([
                                     'user_id'            => $user->user_id,
                                     'message'            => $text,
                                     'parent_id'          => $ticket->ticket_id,
                                     'ticket_category_id' => $ticket->category_id,
                                 ])) {
                    return response(['message' => "پاسخ با موفقیت ثبت شد"]);
                }
                return response(['message' => "خطایی در ثبت پاسخ رخ داد"], 400);
            });
            $router->post('/submit', $this->middleware($router), function () {
                /** @var UsersEntity $user */
                $user = Users::findToken(get_header('auth'));

                //$name = $this->getParam('name');
                $text = $this->getParam('message');
                $category_id = $this->getParam('categoryId');
                //$email = $this->getParam('email');
                //$phone = $this->getParam('phone');
                if (
                    Tickets::add([
                                     'user_id'            => $user->user_id,
                                     'message'            => $text,
                                     'name'               => $user->user_name ? $user->user_name.'' : ' بدون نام',
                                     'mobile'             => $user->user_mobile . '',
                                     'email'              => $user->user_email . '',
                                     'ticket_category_id' => $category_id,
                                 ])) {
                    return response(['message' => "تیکت با موفقیت ثبت شد"]);
                }
                return response(['message' => "خطایی در ثبت پاسخ رخ داد"], 400);
            });

        });

        $router->group('/site-ticket', function (Router $router) {
            $router->get('/list', $this->middleware($router), function () {
                $user = Users::findToken(get_header('auth'));
                $comments = Tickets::Db()->where('user_id', $user->user_id)->where('parent_id', 0)->orderBy('created_at', true)->get()->map(function (TicketsEntity $comments) {
                    return $comments->apiFormat();
                });
                return response($comments, 201);
            });
            $router->any('/ticket/:id', $this->middleware($router), function ($id) {
                $user = Users::findToken(get_header('auth'));
                $ticket = \model\Tickets::get($id);
                /** @var TicketsEntity $ticket */
                return response($ticket->apiFormat(), 201);
            });
            $router->any('/categories', function () {
                return response(TicketCategories::Db()->get()->map(function (TicketCategoriesEntity $ticketCategories) {
                    return $ticketCategories->apiFormat();
                })->values());
            });
            $router->post('/answer', $this->middleware($router), function () {
                $user = Users::findToken(get_header('auth'));
                $ticket = Tickets::get($this->getParam('id'));
                $text = $this->getParam('text');
                if (
                    Tickets::add([
                                     'user_id'            => $user->user_id,
                                     'message'            => $text,
                                     'parent_id'          => $ticket->ticket_id,
                                     'ticket_category_id' => $ticket->category_id,
                                 ])) {
                    return response(['message' => "پاسخ با موفقیت ثبت شد"]);
                }
                return response(['message' => "خطایی در ثبت پاسخ رخ داد"], 400);
            });
            $router->post('/submit', $this->middleware($router), function () {
                $user = Users::findToken(get_header('auth'));

                $name = $this->getParam('name', false);
                $text = $this->getParam('message');
                $category_id = $this->getParam('categoryId');
                $email = $this->getParam('email', false);
                $mobile = $this->getParam('mobile', false);
                if (
                    Tickets::add([
                                     'user_id'            => $user->user_id,
                                     'message'            => $text,
                                     'name'               => $name ?: $user->user_name,
                                     'mobile'             => $mobile ?: $user->user_mobile,
                                     'email'              => $email ?: $user->user_email,
                                     'ticket_category_id' => $category_id,
                                 ])) {
                    return response(['message' => "تیکت با موفقیت ثبت شد"]);
                }
                return response(['message' => "خطایی در ثبت پاسخ رخ داد"], 400);
            });

        });


        $router->group('/app', function (Router $router) {
            $router->get('/about-us', function () {
                /** @var AppAboutUsEntity $aboutUs */
                $aboutUs = AppAboutUs::get(1);
                return response([
                                    'image' => __IMAGES__ . 'AppAboutUs/' . $aboutUs->about_us_image,
                                    'text'  => $aboutUs->about_us_text,
                                ]);
            });
            $router->get('/rules', function () {
                /** @var RulesEntity $aboutUs */
                $rule = Rules::get(1);
                return response([
                                    'rule' => $rule->rules,
                                ]);
            });

        });

        $router->group('/site', function (Router $router) {
            $router->get('/about-us', function () {
                /** @var AboutUsEntity $aboutUs */
                $aboutUs = AboutUs::get(1);
                return response([
                                    'data' => $aboutUs->apiFormat()
                                ]);
            });
            $router->get('/contact-us', function () {
                /** @var ContactUsEntity $data */
                $data = ContactUs::get(1);
                return response([
                                    'data' => $data->apiFormat(),
                                ]);
            });

        });
    }

    public function requiredHeaders(): array {
        return $this->auth();
    }


}
