<?php

header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Headers: *");
ini_set('error_reporting', E_ALL);
ini_set('display_errors', E_ALL);

use FwRoutingSystem\Router;
use model\AdTimes;
use model\Entity\AdTempFilesEntity;
use model\Entity\AudioBooksEntity;
use model\Entity\EpisodesEntity;
use model\Entity\StoriesEntity;
use model\PaymentTable;
use model\Transactions;
use model\Views;

include 'src/autoload.php';

const __HOST__ = 'https://nahid-golkar.ir/admin';
define("__IMAGES__", 'https://' . str(FwConfig::HOST())->explode('/')[0] . '/admin/src/images/');
const __FILES__ = __HOST__ . '/src/images/Files/';
$Router = new Router();
$Router->__defaults();
//$Router->get('/update_users', function () {
//	FwConnection::$conn = FwConnection::conn2();
//	$users = \model\Users::Db()->where('mobile', 'not like', "+98%")->get();
//	$res = [];
//	foreach ($users as $user) {
//
//		$mobile = $user->mobile;
//		echo $mobile.'<br>';
//		if ($mobile[0] == "0") {
//			$mobile = substr($mobile, 1);
//		}
//		$res[] = \model\Users::edit($user->user_id, [
//			'mobile' => "+98" . $mobile,
//		]);
//	}
//	return $res;
//});
$Router->get('/calculate_shares', function () {
    $totalAmount = PaymentTable::Db()->where('payment_status', 1)->where('payment_type', 'like', '%buyPlan%')->sum('payment_amount') / 10;
    $totalAmount -= \model\Checkpoints::allSum();
    $artistsShare = $totalAmount * 0.1;
    $totalViews = \model\Views::Db()->rowCount();


    $artists = \model\Artists::Db()->get();

    $logs = [];
    foreach ($artists as $artist) {
        $views = Views::Db()->where('artist_id', $artist->artist_id)->rowCount();
        if ($views > 0) {
            $percent = ($views / $totalViews);
            $share = $artistsShare * $percent;
            $totalShares = Transactions::Db()->where('artist_id', $artist->artist_id)->where('transaction_type', Transactions::calculateShare)->where('status', 1)->rowCount();
            $left = $share - $totalShares;
            if ($left > 0) {
                $transaction = Transactions::add([
                                                     'artist_id'           => $artist->artist_id,
                                                     'transaction_amount'  => $left,
                                                     'transaction_type'    => Transactions::calculateShare,
                                                     'status'              => 1,
                                                     'transaction_notes'   => "واریز سهم بازدید بر اساس $views بازدید",
                                                     'wallet_pre_balance'  => $artist->wallet,
                                                     'wallet_post_balance' => $artist->wallet + $left,
                                                 ]);
                if ($transaction) {
                    if (\model\Artists::edit($artist->artist_id, ['artist_wallet' => $artist->wallet + $left])) {
                        $user = \model\Users::Db()->where('artist_id', $artist->artist_id)->orderBy('created_at', true)->limit(1)->get()->last;
                        if ($user instanceof \model\Entity\UsersEntity){
                        sendSmsPattern($user->mobile, 302633, [
                            price_format($left),
                            $artist->artist_name,
                        ],             $user);
                        }
                        $logs[] = "Calculate Share for $artist->artist_name with the id of: $artist->artist_id; Calculated Share: $left successful";
                    } else {
                        Transactions::delete($transaction);
                        $logs[] = "Calculate Share for $artist->artist_name with the id of: $artist->artist_id; Calculated Share: $left failed after submitting the transaction";
                    }
                } else {
                    $logs[] = "Calculate Share for $artist->artist_name with the id of: $artist->artist_id; Calculated Share: $left failed before submitting the transaction";
                }
            }
        }
    }
    file_put_contents(__SOURCE__ . 'logs/calculate_shares_log', @file_get_contents(__SOURCE__ . 'logs/calculate_shares_log') . "\n" . date("d.m.Y H:i:s")."\n" . implode("\n", $logs) . "\n" . date("d.m.Y H:i:s") . "\n\n");

});
$Router->get('/calculate_views', function () {
    $stories = \model\Stories::Db()->where('status', 1)->get();
    /** @var StoriesEntity $story */
    $logs = [];
    $count = 0;

    foreach ($stories as $story) {
        $episodes = \model\Episodes::Db()->where('story_id', $story->story_id)->where('status', 1)->get();
        /** @var EpisodesEntity $episode */
        $storyViews = 0;
        $storyComments = 0;
        $storyLikes = 0;
        foreach ($episodes as $episode) {
            $views = Views::Db()->where('content_id', $episode->episode_id)->where('story_id', $story->story_id)->rowCount();
            $likes = \model\Likes::Db()->where('episode_id', $episode->episode_id)->where('story_id', $story->story_id)->rowCount();
            $comments = \model\Comments::Db()->where('episode_id', $episode->episode_id)->where('story_id', $story->story_id)->rowCount();
            if ($views > $episode->views or $comments > $episode->comments or $likes > $episode->likes) {
                if (\model\Episodes::edit($episode->episode_id, ['views' => $views, 'comments' => $comments, 'likes' => $likes])) {
                    $storyViews += $views;
                    $storyComments += $comments;
                    $storyLikes += $likes;
                    $count++;
                    echo "$count<br>";
                }
            }
        }
        if ($storyViews > $story->views or $storyComments > $story->comments or $storyLikes > $story->likes) {
            if (\model\Stories::edit($story->story_id, ['views' => $storyViews, 'comments' => $storyComments, 'likes' => $storyLikes])) {
                $logs[] = "$storyViews views and $storyLikes likes and $storyViews comments calculated for $story->story_id $story->name";
            }
        }
    }
    file_put_contents(__SOURCE__ . 'logs/calculate_views_log', @file_get_contents(__SOURCE__ . 'logs/calculate_views_log') . "\n" . date("d.m.Y H:i:s") ."\n". implode("\n", $logs) . "\n" . date("d.m.Y H:i:s") . "\n\n");
    $audioBooks = \model\AudioBooks::Db()->where('status', 1)->get();
    /** @var AudioBooksEntity $audioBook */
    $logs = [];

    foreach ($audioBooks as $audioBook) {
        $episodes = \model\AudioBookEpisodes::Db()->where('audio_book_id', $audioBook->audio_book_id)->where('status', 1)->get();
        /** @var \model\Entity\AudioBookEpisodesEntity $episode */
        $audioBookViews = 0;
        $audioBookComments = 0;
        $audioBookLikes = 0;
        foreach ($episodes as $episode) {
            $views = Views::Db()->where('content_id', $episode->audio_book_episode_id)->where('audio_book_id', $audioBook->audio_book_id)->rowCount();
            $likes = \model\Likes::Db()->where('episode_id', $episode->audio_book_episode_id)->where('audio_book_id', $audioBook->audio_book_id)->rowCount();
            $comments = \model\Comments::Db()->where('episode_id', $episode->audio_book_episode_id)->where('audio_book_id', $audioBook->audio_book_id)->rowCount();
            if ($views > $episode->views or $comments > $episode->comments or $likes > $episode->likes) {
                if (\model\AudioBookEpisodes::edit($episode->audio_book_episode_id, ['views' => $views, 'comments' => $comments, 'likes' => $likes])) {
                    $audioBookViews += $views;
                    $audioBookComments += $comments;
                    $audioBookLikes += $likes;
                    $count++;
                    echo "$count<br>";
                }
            }
        }
        if ($audioBookViews > $audioBook->views or $audioBookComments > $audioBook->comments or $audioBookLikes > $audioBook->likes) {
            if (\model\AudioBooks::edit($audioBook->audio_book_id, ['views' => $audioBookViews, 'comments' => $audioBookComments, 'likes' => $audioBookLikes])) {
                $logs[] = "$audioBookViews views and $audioBookLikes likes and $audioBookViews comments calculated for $audioBook->audio_book_id $audioBook->book_name";
            }
        }
    }
    file_put_contents(__SOURCE__ . 'logs/calculate_views_log', @file_get_contents(__SOURCE__ . 'logs/calculate_views_log') . "\n" . date("d.m.Y H:i:s") ."\n". implode("\n", $logs) . "\n" . date("d.m.Y H:i:s") . "\n\n");

});
$Router->get('/update_views', function () {
    $views = \model\Views::Db()->where('artist_id', 0)->get();
    foreach ($views as $view) {
        if ($view->content_type == 'audio_book' and $view->artist_id == 0) {
            $book = \model\AudioBooks::get($view->audio_book_id);
            if ($book instanceof AudioBooksEntity) {
                \model\Views::edit($view->view_id, [
                    'artist_id' => $book->artist_id,
                ]);
            }
        } elseif ($view->content_type == 'story' and $view->artist_id == 0) {
            $story = \model\Stories::get($view->story_od);
            if ($story instanceof StoriesEntity) {
                \model\Views::edit($view->view_id, [
                    'artist_id' => $story->artist_id,
                ]);
            }
        }
    }
});
//$Router->get('/convert_dates', function () {
//    $ads = \model\Ads::getAll();
//    foreach ($ads as $ad) {
//        $times = json_decode($ad->ad_times);
//        $arr = [];
//        if ($times) {
//            foreach ($times as $time) {
//                if ($time->price > 0) {
//                    $arr[] = AdTimes::add([
//                        'ad_time_from'  => $time->from,
//                        'ad_time_to'    => $time->to,
//                        'ad_time_price' => $time->price,
//                        'ad_id'         => $ad->id,
//                    ]);
//                }
//            }
//            if (count($arr) > 0) {
//                echo json_encode($arr) . '<br>';
//                var_dump(\model\Ads::edit($ad->ad_id, [
//                    'ad_times' => json_encode($arr),
//                ]));
//                echo "<br>";
//            }
//        }
//    }
//});
//$Router->post('/uploadAdFile/:string', function ($token) {
//    $token = \model\AdTokens::getOneFiltered('ad_token', $token);
//    if ($token instanceof \model\Entity\AdTokensEntity) {
//        $name = upload($_FILES['file'], __SOURCE__ . 'images/AdTempFiles/');
//        if (\model\AdTempFiles::add([
//            'ad_temp_file_token' => $token->token,
//            'ad_temp_file'       => $name,
//            'ad_temp_file_name'  => $_FILES['file']['name'],
//        ])) {
//            return 'فایل با موفقیت آپلود شد';
//        }
//    }
//    http_send_status(500);
//    return "آپلود با خطا مواجه شد";
//});
//$Router->post('/removeFile/:string', function ($token) {
//    $fileName = $_POST['fileName'];
//    /** @var AdTempFilesEntity $first */
//    $res = \model\AdTempFiles::Db()->where([
//        'ad_temp_file_token' => $token,
//        'ad_temp_file_name'  => $fileName,
//    ])->get();
//    if ($res->length() > 0) {
//        $first = $res->first;
//        if ($first->delete()) {
//            return 'ok';
//        }
//    }
//    http_send_status(500);
//    return "حذف با خطا مواجه شد";
//});
$Router->get('/react/:string', function ($age) {
    $ageFirst = $age[0];
    $ageFirst = strtoupper($ageFirst);
    $ageTwo = $age;
    $ageTwo[0] = $ageFirst;
    return "const [$age,set$ageTwo" . "s] = useState();";
});
//$Router->get('/entity', function () {
//    if ($res = FwConnection::conn()->query("DESCRIBE tblAds")) {
//        while ($row = $res->fetchObject()) {
//            echo "public \$" . $row->Field . ";<br>";
//        }
//    }
//});
