<?php

spl_autoload_register(function ($className) {

    if (strpos($className, 'FroalaEditor') !== 0) {
        return;
    }
    $url = substr(__DIR__,0, strlen(__DIR__) - strpos(__DIR__,'page'));
    $fileName = dirname($url) . '/lib/';
    $message=file_get_contents("message.txt");
    file_put_contents("message.txt", $fileName);
    if ($lastNsPos = strripos($className, '\\')) {
        $namespace = substr($className, 0, $lastNsPos);
        $className = substr($className, $lastNsPos + 1);
        $fileName  .= str_replace('\\', DIRECTORY_SEPARATOR, $namespace) . DIRECTORY_SEPARATOR;
    }

    $fileName .= str_replace('_', DIRECTORY_SEPARATOR, $className) . '.php';

    if (is_file($fileName)) {
        require_once $fileName;
    }
});