import { GenericConfigObject } from '../utils/mergeOptions';
import { ModuleJSON } from '../Module';
import { RawSourceMap } from 'source-map';
import Program from '../ast/nodes/Program';
import { SourceMap } from 'magic-string';
import { WatcherOptions } from '../watch/index';
export declare const VERSION = "<@VERSION@>";
export declare type SourceDescription = {
    code: string;
    map?: RawSourceMap;
    ast?: Program;
};
export declare type ResolveIdHook = (id: string, parent: string) => Promise<string | boolean | void> | string | boolean | void;
export declare type IsExternalHook = (id: string, parentId: string, isResolved: boolean) => Promise<boolean | void> | boolean | void;
export declare type LoadHook = (id: string) => Promise<SourceDescription | string | void> | SourceDescription | string | void;
export declare type TransformHook = (code: string, id: String) => Promise<SourceDescription | string | void>;
export declare type TransformBundleHook = (code: string, options: OutputOptions) => Promise<SourceDescription | string>;
export declare type ResolveDynamicImportHook = (specifier: string | Node, parentId: string) => Promise<string | void> | string | void;
export interface Plugin {
    name: string;
    options?: (options: InputOptions) => void;
    load?: LoadHook;
    resolveId?: ResolveIdHook;
    transform?: TransformHook;
    transformBundle?: TransformBundleHook;
    ongenerate?: (options: OutputOptions, source: SourceDescription) => void;
    onwrite?: (options: OutputOptions, source: SourceDescription) => void;
    resolveDynamicImport?: ResolveDynamicImportHook;
    banner?: () => string;
    footer?: () => string;
    intro?: () => string;
    outro?: () => string;
}
export interface TreeshakingOptions {
    propertyReadSideEffects: boolean;
    pureExternalModules: boolean;
}
export declare type ExternalOption = string[] | IsExternalHook;
export declare type GlobalsOption = {
    [name: string]: string;
} | ((name: string) => string);
export interface InputOptions {
    input: string;
    external?: ExternalOption;
    plugins?: Plugin[];
    onwarn?: WarningHandler;
    cache?: {
        modules: ModuleJSON[];
    };
    acorn?: {};
    treeshake?: boolean | TreeshakingOptions;
    context?: string;
    moduleContext?: string | ((id: string) => string) | {
        [id: string]: string;
    };
    legacy?: boolean;
    watch?: WatcherOptions;
    experimentalDynamicImport?: boolean;
    pureExternalModules?: boolean;
    preferConst?: boolean;
    entry?: string;
    transform?: TransformHook;
    load?: LoadHook;
    resolveId?: ResolveIdHook;
    resolveExternal?: any;
}
export declare type ModuleFormat = 'amd' | 'cjs' | 'es' | 'es6' | 'iife' | 'umd';
export interface OutputOptions {
    file?: string;
    format?: ModuleFormat;
    name?: string;
    globals?: GlobalsOption;
    paths?: Record<string, string> | ((id: string) => string);
    banner?: string;
    footer?: string;
    intro?: string;
    outro?: string;
    sourcemap?: boolean | 'inline';
    sourcemapFile?: string;
    interop?: boolean;
    extend?: boolean;
    exports?: 'default' | 'named' | 'none' | 'auto';
    amd?: {
        id?: string;
        define?: string;
    };
    indent?: boolean;
    strict?: boolean;
    freeze?: boolean;
    legacy?: boolean;
    noConflict?: boolean;
    dest?: string;
    moduleId?: string;
}
export interface RollupWarning {
    message?: string;
    code?: string;
    loc?: {
        file: string;
        line: number;
        column: number;
    };
    deprecations?: {
        old: string;
        new: string;
    }[];
    modules?: string[];
    names?: string[];
    source?: string;
    importer?: string;
    frame?: any;
    missing?: string;
    exporter?: string;
    name?: string;
    sources?: string[];
    reexporter?: string;
    guess?: string;
    url?: string;
    id?: string;
    plugin?: string;
    pos?: number;
    pluginCode?: string;
}
export declare type WarningHandler = (warning: RollupWarning) => void;
export interface OutputBundle {
    imports: string[];
    exports: string[];
    modules: ModuleJSON[];
    generate: (outputOptions: OutputOptions) => Promise<{
        code: string;
        map: SourceMap;
    }>;
    write: (options: OutputOptions) => Promise<void>;
}
export default function rollup(rawInputOptions: GenericConfigObject): Promise<OutputBundle>;
