<?php

namespace DATABASE\ORM\QueryBuilder\QueryBuilder;

use stdClass;

final class Db {
	use QueryBuilder;
	
	public $_key;
	/**
	 * @var string
	 */
	private $_table;
	private $_Entity = stdClass::class;
	
	public function __construct(string $table_name, $_Entity = stdClass::class) {
		$this->_table = $table_name;
		$this->_Entity = $_Entity;
		$this->__start();
	}
	
	public static function table(string $table_name) {
		return new self($table_name);
	}
	
	public static function tableFromEntity(string $_table, $_Entity) {
		
		return new self($_table, $_Entity);
	}
	
	public function reset() {
		if (!($this->_Entity instanceof stdClass)) {
			return new self($this->_table, $this->_Entity);
		}
		return new self($this->_table);
	}
	
	
}
