<?php

namespace model\Entity;

use DATABASE\ORM\Interact\Entities\EntityScheme;

class BlogsEntity extends EntityScheme
{
    public $blog_id;
    public $title;
    public $content;
    public $image;
    public $date;
    public $tag_ids;
    public $category_id;
    public $views_count;
    public $meta_description;
    public $slug;
    public $updated_at;


    public function model()
    {
        return new \model\Blogs();
    }

    public function apiFormat()
    {
        /** @var BlogCategoriesEntity $category */
        $category = \model\BlogCategories::get($this->category_id);


        return [
            'id' => $this->blog_id,
            'title' => $this->title,
            'content' => $this->content,
            'image' => __IMAGES__ . 'Blogs/' . $this->image,
            'date' => $this->date,
            'category' => $category->apiFormat(),
        ];
    }

    public function singleApiFormat()
    {
        /** @var BlogCategoriesEntity $category */
        $category = \model\BlogCategories::get($this->category_id);
        $comments = \model\BlogComments::Db()->where('blog_id',$this->blog_id)->get()->map(function (BlogCommentsEntity $comment){
            return $comment->apiFormat();
        });
        return [
            'id' => $this->blog_id,
            'title' => $this->title,
            'category' => $category->apiFormat(),
            'date' => $this->date,
            'view' => $this->views_count,
            'content' => $this->content,
            'image' => __IMAGES__ . 'Blogs/' . $this->image,
            'comments' => $comments,
        ];
    }


    protected function dictionary(): array
    {
        return [
            'blog_id' => 'blog_id',
            'title' => 'blog_title',
            'content' => 'blog_content',
            'image' => 'blog_image',
            'date' => 'blog_date',
            'slug' => 'blog_slug',
        ];
    }
}
