<?php

namespace model\Entity;

use DATABASE\ORM\Interact\Entities\EntityScheme;
use model\Providers;
use model\Users;

class CommentsEntity extends EntityScheme {
    public $comment_id;
    /**
     * کاربر
     **/
    public $user_id;
    /**
     * پذیرنده
     **/
    public $provider_id;
    /**
     * نظر
     **/
    public $comment;
    public $anonymous;
    public $rate;

    public function model() {
        return new \model\Comments();
    }


    protected function dictionary(): array {
        return [
            'comment_id'  => 'comment_id',
            'user_id'     => 'user_id',
            'provider_id' => 'provider_id',
            'comment'     => 'comment',
            'anonymous'     => 'anonymous',
            'rate'        => 'rate',
        ];
    }

    public function apiFormat(): array {
        $user = Users::get($this->user_id);
        /** @var UsersEntity $user */
        if ($this->anonymous == 1 || !$user instanceof UsersEntity) {
            $userFormat = [
                'id'           => 0,
                'image'        => __IMAGES__ . 'Users/placeholder.png',
                'name'         => "دوست آنیکارتی",
                'mobile'       => "",
                'currentLimit' => 0,
            ];
        }else{
            $userFormat = $user->providerFormat();
        }
        return [
            'id'        => $this->comment_id,
            'user'      => $userFormat,
            'comment'   => $this->comment,
            'rate'      => $this->rate,
            'anonymous' => $this->anonymous,
            'createdAt' => strtotime($this->created_at),

        ];
    }


    public function userApiFormat(): array {
        $provider = Providers::get($this->provider_id);
        /** @var ProvidersEntity $provider */
        return [
            'id'        => $this->comment_id,
            'provider'  => $provider->sliderFormat(),
            'comment'   => $this->comment,
            'rate'      => $this->rate,
            'createdAt' => strtotime($this->created_at),

        ];
    }

}
