<?php

namespace model\Entity;

use DATABASE\ORM\Interact\Entities\EntityScheme;

class CompaniesEntity extends EntityScheme
{
    public $company_id;
    /**
     * نام شرکت
     **/
    public $name;
    /**
     * لوگو
     **/
    public $logo;
    public $image;
    public $link;

    public function model()
    {
        return new \model\Companies();
    }


    protected function dictionary(): array
    {
        return [
            'company_id' => 'company_id',
            'name' => 'company_name',
            'logo' => 'company_logo',
            'image' => 'company_image',
            'link' => 'company_link',
        ];
    }

    public function apiFormat(): array
    {
        return [
            'id' => $this->company_id,
            'name' => $this->name,
            'logo' => $this->logo?__IMAGES__ . 'Companies/' . $this->logo:"",
            'image' => $this->image ? __IMAGES__ . 'Companies/' . $this->image :"",
            'link' => $this->link,
        ];
    }

}
