<?php

namespace model\Entity;

use DATABASE\ORM\Interact\Entities\EntityScheme;

class ContactUsEntity extends EntityScheme
{
    public $contact_us_id;
    /**
     * عنوان
     **/
    public $us_title;
    /**
     * توضیحات
     **/
    public $us_description;
    /**
     * تصویر
     **/
    public $us_image;
    /**
     * تصویر سوالات پرتکرار
     **/
    public $us_faq_image;
    public $social_icon1;
    public $social_icon2;
    public $social_icon3;
    public $social_icon4;
    public $social_title1;
    public $social_title2;
    public $social_title3;
    public $social_title4;
    public $social_name1;
    public $social_name2;
    public $social_name3;
    public $social_name4;
    public $social_link1;
    public $social_link2;
    public $social_link3;
    public $social_link4;
    public $license_icon1;
    public $license_icon2;
    public $license_icon3;
    public $license_link1;
    public $license_link2;
    public $license_link3;
    public $license_name1;
    public $license_name2;
    public $license_name3;
    public $license_status1;
    public $license_status2;
    public $license_status3;

    public function model()
    {
        return new \model\ContactUs();
    }

    public function apiFormat()
    {
        $setting = \model\Settings::get(1);

        $license_1 = [
            'icon' => __IMAGES__ . 'ContactUs/' . $this->license_icon1,
            'name' => $this->license_name1,
            'link' => $this->license_link1 ?: null,
            'status' => $this->license_status1==1?true:false,
        ];
        $license_2 = [
            'icon' => __IMAGES__ . 'ContactUs/' . $this->license_icon2,
            'name' => $this->license_name2,
            'link' => $this->license_link2 ?: null,
            'status' => $this->license_status2==1?true:false,
        ];
        $license_3 = [
            'icon' => __IMAGES__ . 'ContactUs/' . $this->license_icon3,
            'name' => $this->license_name3,
            'link' => $this->license_link3 ?: null,
            'status' => $this->license_status3==1?true:false,
        ];

        $social_1 = [
            'icon' => __IMAGES__ . 'ContactUs/' . $this->social_icon1,
            'title' => $this->social_title1,
            'name' => $this->social_name1,
            'link' => $this->social_link1
        ];

        $social_2 = [
            'icon' => __IMAGES__ . 'ContactUs/' . $this->social_icon2,
            'title' => $this->social_title2,
            'name' => $this->social_name2,
            'link' => $this->social_link2
        ];

        $social_3 = [
            'icon' => __IMAGES__ . 'ContactUs/' . $this->social_icon3,
            'title' => $this->social_title3,
            'name' => $this->social_name3,
            'link' => $this->social_link3
        ];

        $social_4 = [
            'icon' => __IMAGES__ . 'ContactUs/' . $this->social_icon4,
            'title' => $this->social_title4,
            'name' => $this->social_name4,
            'link' => $this->social_link4
        ];
        $faq = \model\Faqs::Db()->where('faq_type', "2")->get()->map(function (FaqsEntity $faq) {
            return $faq->apiFormat();
        });
        return [
            'title' => $this->us_title,
            'text' => $this->us_description,
            'image' => __IMAGES__ . 'ContactUs/' . $this->us_image,
            'tel' => $setting->setting_tel,
            'licenses' => [
                $license_1,
                $license_2,
                $license_3
            ],
            'socials' => [
                $social_1,
                $social_2,
                $social_3,
                $social_4,
            ],
            'workingDays' => $setting->working_days,
            'workingHours' => $setting->working_hours,
            'faq_image' => __IMAGES__ . 'ContactUs/' . $this->us_faq_image,
            'faq' => $faq,


        ];
    }


    protected function dictionary(): array
    {
        return [
            'contact_us_id' => 'contact_us_id', 'us_title' => 'contact_us_title', 'us_description' => 'contact_us_description', 'us_image' => 'contact_us_image', 'us_faq_image' => 'contact_us_faq_image',
        ];
    }
}
