<?php

namespace model\Entity;

use DATABASE\ORM\Interact\Entities\EntityScheme;
use model\Providers;

class SlidersEntity extends EntityScheme {
    public $slider_id;
    /**
     * عنوان
     **/
    public $title;
    /**
     * متن
     **/
    public $text;
    /**
     * پذیرندگان
     **/
    public $provider_ids;

    public function model() {
        return new \model\Sliders();
    }


    protected function dictionary(): array {
        return [
            'slider_id' => 'slider_id', 'title' => 'slider_title', 'text' => 'slider_text', 'provider_ids' => 'provider_ids',
        ];
    }

    public function apiFormat(): array {
        $providerIds = json_decode($this->provider_ids, true);
        $providers = Providers::Db()->whereIn('provider_id', $providerIds)->get()->map(function (ProvidersEntity $provider) {
            return $provider->sliderFormat();
        });
        return [
            'id'        => $this->slider_id,
            'title'     => $this->title,
            'text'      => $this->text,
            'providers' => $providers,
        ];
    }

}
