<?php

namespace model\Entity;

use DATABASE\ORM\Interact\Entities\EntityScheme;

class TicketCategoriesEntity extends EntityScheme {
    public $ticket_category_id;
    /**
     * نام دسته بندی
     **/
    public $name;

    public function model() {
        return new \model\TicketCategories();
    }


    protected function dictionary(): array {
        return [
            'ticket_category_id' => 'ticket_category_id', 'name' => 'ticket_category_name',
        ];
    }

    public function apiFormat(): array {
        return [
            'id'   => $this->ticket_category_id,
            'name' => $this->name
        ];
    }

}
