<?php

namespace model\Entity;

use DATABASE\ORM\Interact\Entities\EntityScheme;

class TopBannersEntity extends EntityScheme {
    public $top_banner_id;
    public $banner_name;
    public $banner;
    public $banner_link;

    public function model() {
        return new \model\TopBanners();
    }


    protected function dictionary(): array {
        return [
            'top_banner_id' => 'top_banner_id',
            'banner_name' => 'banner_name',
            'banner' => 'banner',
            'banner_link' => 'banner_link',
        ];
    }

    public function apiFormat(): array {
        return [
            'id'     => $this->top_banner_id,
            'banner' => __IMAGES__ . 'TopBanners/' . $this->banner,
            'link'   => $this->banner_link,
            'type'   => 'top',
        ];
    }

}
