<?php

namespace model\Entity;

use DATABASE\ORM\Interact\Entities\EntityScheme;

class WelcomePageEntity extends EntityScheme
{
    public $welcome_page_id;
    public $title;
    public $description;
    public $right_image;
    public $left_image;


    public function model()
    {
        return new \model\WelcomePage();
    }

    public function apiFormat()
    {
        return [
            'title' => $this->title,
            'description' => $this->description,
            'rightImage' => __IMAGES__ .'WelcomePage/'.$this->right_image,
            'leftImage' => __IMAGES__.'WelcomePage/'.$this->left_image
        ];

    }


    protected function dictionary(): array
    {
        return [
            'welcome_page_id' => 'welcome_page_id',
            'title' => 'welcome_title',
            'description' => 'welcome_description',
            'right_image' => 'welcome_right_image',
            'left_image' => 'welcome_left_image',
        ];
    }
}
