<?php

namespace model\Entity;

use DATABASE\ORM\Interact\Entities\EntityScheme;

class WithdrawRequestsEntity extends EntityScheme {
    public $withdraw_request_id;
    /**
     * انتخاب کاربر
     **/
    public $user_id;
    /**
     * مبلغ
     **/
    public $request_amount;
    /**
     * شماره شبا
     **/
    public $request_sheba;
    /**
     * وضعیت
     **/
    public $request_status;
    public $request_note;

    public function model() {
        return new \model\WithdrawRequests();
    }


    protected function dictionary(): array {
        return [
            'withdraw_request_id' => 'withdraw_request_id', 'user_id' => 'user_id', 'request_amount' => 'request_amount', 'request_sheba' => 'request_sheba', 'request_status' => 'request_status',
        ];
    }

    public function apiFormat(): array {
        return [
            'id'         => $this->withdraw_request_id,
            'amount'     => $this->request_amount,
            'sheba'      => $this->request_sheba,
            'status'     => $this->request_status,
            'note'       => $this->request_note,
            'created_at' => strtotime($this->created_at) * 1000,
        ];
    }

}
