<?php

namespace FwMigrationSystem\User;

use FwMigrationSystem\Main\Migratable;
use FwMigrationSystem\Main\Migration;
use FwMigrationSystem\Resources\Blueprint;
use FwMigrationSystem\Resources\TableName;

class FiltersMigration extends Migratable {
    const modelName = 'Filters';

    public function create_table() {
        return Migration::Create(new TableName(self::modelName), function (Blueprint $blueprint) {
            $blueprint->primary_key('filter_id');
			$blueprint->VarChar('filter_name')->Len(150);
			$blueprint->Int('file_id')->Len(150);
			$blueprint->Text('first_categories');
			$blueprint->Text('second_categories');
			$blueprint->Text('third_categories');
			$blueprint->Text('light_types');
			$blueprint->Int('materials')->Len(150);
			$blueprint->Int('banner_types')->Len(150);
			$blueprint->Int('view_conditions')->Len(150);
			$blueprint->Int('viewer_ages')->Len(150);
			$blueprint->Int('viewer_types')->Len(150);
			$blueprint->Int('business_types')->Len(150);
			$blueprint->Int('cancel_type_id')->Len(150);
			$blueprint->Datetime('created_at')->Default('CURRENT_TIMESTAMP()');

             return $blueprint;
        });
    }

    public function drop_table() {
        return Migration::DropIfExists(new TableName(self::modelName));
    }
}
