<?php

namespace FwMigrationSystem\User;

use FwMigrationSystem\Main\Migratable;
use FwMigrationSystem\Main\Migration;
use FwMigrationSystem\Resources\Blueprint;
use FwMigrationSystem\Resources\TableName;

class TicketsMigration extends Migratable {
    const modelName = 'Tickets';

    public function create_table() {
        return Migration::Create(new TableName(self::modelName), function (Blueprint $blueprint) {
            $blueprint->primary_key('ticket_id');
			$blueprint->VarChar('ticket_title')->Len(150);
			$blueprint->Int('ticket_subject_id')->Len(150);
			$blueprint->Int('user_id')->Len(150);
			$blueprint->Text('ticket_text');
			$blueprint->Datetime('created_at')->Default('CURRENT_TIMESTAMP()');

             return $blueprint;
        });
    }

    public function drop_table() {
        return Migration::DropIfExists(new TableName(self::modelName));
    }
}
