<?php

namespace FwMigrationSystem\User;

use FwMigrationSystem\Main\Migratable;
use FwMigrationSystem\Main\Migration;
use FwMigrationSystem\Resources\Blueprint;
use FwMigrationSystem\Resources\TableName;

class WorkerReviewsMigration extends Migratable {
    const modelName = 'WorkerReviews';

    public function create_table() {
        return Migration::Create(new TableName(self::modelName), function (Blueprint $blueprint) {
            $blueprint->primary_key('worker_review_id');
			$blueprint->Int('user_id')->Len(150);
			$blueprint->Int('worker_service_id')->Len(150);
			$blueprint->Int('worker_review_rate')->Len(150);
			$blueprint->Text('worker_review_text');
			$blueprint->Datetime('created_at')->Default('CURRENT_TIMESTAMP()');

             return $blueprint;
        });
    }

    public function drop_table() {
        return Migration::DropIfExists(new TableName(self::modelName));
    }
}
