<?php

namespace FwMigrationSystem\User;

use FwMigrationSystem\Main\Migratable;
use FwMigrationSystem\Main\Migration;
use FwMigrationSystem\Resources\Blueprint;
use FwMigrationSystem\Resources\TableName;

class JobsMigration extends Migratable {
    const modelName = 'Jobs';

    public function create_table() {
        return Migration::Create(new TableName(self::modelName), function (Blueprint $blueprint) {
            $blueprint->primary_key('job_id');
			$blueprint->VarChar('job_type')->Len(150);
			$blueprint->Int('category_id')->Len(150);
			$blueprint->VarChar('job_name')->Len(150);
			$blueprint->VarChar('title_license')->Len(150);
			$blueprint->VarChar('manager_name')->Len(150);
			$blueprint->VarChar('job_tel')->Len(150);
			$blueprint->VarChar('job_manager_tel')->Len(150);
			$blueprint->VarChar('job_email')->Len(150);
			$blueprint->Text('social_page_address');
			$blueprint->Int('country_id')->Len(150);
			$blueprint->Int('state_id')->Len(150);
			$blueprint->Int('city_id')->Len(150);
			$blueprint->VarChar('job_building')->Len(150);
			$blueprint->Text('job_address');
			$blueprint->VarChar('job_latitude')->Len(150);
			$blueprint->VarChar('job_longitude')->Len(150);
			$blueprint->Int('job_status')->Len(150);
			$blueprint->VarChar('license_issue_date')->Len(150);
			$blueprint->VarChar('license_expire_date')->Len(150);
			$blueprint->VarChar('licence_file')->Len(150);
			$blueprint->Text('description');
			$blueprint->VarChar('brand_logo')->Len(150);
			$blueprint->Datetime('created_at')->Default('CURRENT_TIMESTAMP()');

             return $blueprint;
        });
    }

    public function drop_table() {
        return Migration::DropIfExists(new TableName(self::modelName));
    }
}
