<?php

namespace FwMigrationSystem\User;

use FwMigrationSystem\Main\Migratable;
use FwMigrationSystem\Main\Migration;
use FwMigrationSystem\Resources\Blueprint;
use FwMigrationSystem\Resources\TableName;

class PoetsMigration extends Migratable {
    const modelName = 'Poets';

    public function create_table() {
        return Migration::Create(new TableName(self::modelName), function (Blueprint $blueprint) {
            $blueprint->primary_key('poet_id');
			$blueprint->VarChar('poet_name')->Len(150);
			$blueprint->Int('time_period_id')->Len(150);
			$blueprint->Int('poetic_style_id')->Len(150);
			$blueprint->Int('poem_theme_id')->Len(150);
			$blueprint->Int('location_id')->Len(150);
			$blueprint->VarChar('poet_image')->Len(150);
			$blueprint->Text('poet_bio');
			$blueprint->Datetime('created_at')->Default('CURRENT_TIMESTAMP()');

             return $blueprint;
        });
    }

    public function drop_table() {
        return Migration::DropIfExists(new TableName(self::modelName));
    }
}
