<?php

namespace FwMigrationSystem\User;

use FwMigrationSystem\Main\Migratable;
use FwMigrationSystem\Main\Migration;
use FwMigrationSystem\Resources\Blueprint;
use FwMigrationSystem\Resources\TableName;

class CharityDonationsMigration extends Migratable {
    const modelName = 'CharityDonations';

    public function create_table() {
        return Migration::Create(new TableName(self::modelName), function (Blueprint $blueprint) {
            $blueprint->primary_key('charity_donation_id');
			$blueprint->Int('user_id')->Len(150);
			$blueprint->Int('charity_id')->Len(150);
			$blueprint->VarChar('donation_price')->Len(150);
			$blueprint->VarChar('donation_image')->Len(150);
			$blueprint->Text('donation_description');
			$blueprint->Datetime('created_at')->Default('CURRENT_TIMESTAMP()');

             return $blueprint;
        });
    }

    public function drop_table() {
        return Migration::DropIfExists(new TableName(self::modelName));
    }
}
