$(function () {
  function generateRandomCode(length = 8) {
    const chars = 'abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789';
    let result = '';
    for (let i = 0; i < length; i++) {
      result += chars.charAt(Math.floor(Math.random() * chars.length));
    }
    return result;
  }

  $('#generate_codes').on('click', function () {
    const count = parseInt($('#code_count').val());
    if (!count || count <= 0) {
      Swal.fire('تعداد معتبر وارد کنید');
      return;
    }

    const planId = $('#global_plan_id').val();
    const expire = $('#global_expire_date').val();
    const referral = $('#global_referral_code').val();

    let table = '<table class="table table-bordered mt-4">';
    table += '<thead><tr>';
    table += '<th>کد آنی کارت</th>';
    table += '<th>نوع اشتراک</th>';
    table += '<th>تاریخ انقضا</th>';
    table += '<th>کد معرف</th>';
    table += '</tr></thead><tbody>';

    for (let i = 0; i < count; i++) {
      const code = generateRandomCode();
      table += '<tr>';
      table += `<td><input type='text' name='codes[${i}][code]' class='form-control' value='${code}' readonly></td>`;
      table += `<td><select name='codes[${i}][plan_id]' class='form-control'>` +
          $('#global_plan_id option').map(function () {
            const selected = $(this).val() == planId ? 'selected' : '';
            return `<option value='${$(this).val()}' ${selected}>${$(this).text()}</option>`;
          }).get().join('') + '</select></td>';
      table += `<td><input type='date' name='codes[${i}][expire_date]' class='form-control' value='${expire}'></td>`;
      table += `<td><input type='text' name='codes[${i}][referral_code]' class='form-control' value='${referral}'></td>`;
      table += '</tr>';
    }

    table += '</tbody></table>';
    $('#generated_codes_table').html(table);
  });
});
