<?

namespace view;

use DOMWrap\Document;
use FwHtml\Elements\Tags\Main\HtmlTags;
use View;

class Companies extends View {

    public $SingularName = 'شرکت';

    public function main(Document &$document) {
        $document->html = $this->Html()->BreadCrumbs() . HtmlTags::Section('.content')
                                                                 ->Content(
                                                                     HtmlTags::Div('.row')
                                                                             ->Content(
                                                                                 HtmlTags::Div('.col-md-12')->Content(
                                                                                     HtmlTags::Div('.card.card-primary.card-outline')
                                                                                             ->Content(
                                                                                                 HtmlTags::Div('.card-header')
                                                                                                         ->Content(
                                                                                                             $this->Html()->CardTitle(),
                                                                                                             $this->Html()->refreshAndAdd()
                                                                                                         ),
                                                                                                 HtmlTags::Div('.card-body.d-flex.flex-wrap')
                                                                                                         ->Content(
                                                                                                             HtmlTags::Table('.table.table-bordered.table-striped')
                                                                                                                     ->Content(
                                                                                                                         HtmlTags::Thead('.table-dark')
                                                                                                                                 ->Content(
                                                                                                                                     HtmlTags::Tr()->Content(
                                                                                                                                         HtmlTags::Th('ردیف')->Width('50'),
                                                                                                                                         HtmlTags::Th('نام شرکت'),
                                                                                                                                         HtmlTags::Th('لوگو'),
                                                                                                                                         HtmlTags::Th('.no-sort عملیات')->Width('150')
                                                                                                                                     )
                                                                                                                                 ),
                                                                                                                         HtmlTags::Tbody()
                                                                                                                                 ->Content(
                                                                                                                                     $this->show([
                                                                                                                                                     'company_name',
                                                                                                                                                     'showImage' => 'company_logo'
                                                                                                                                                 ])
                                                                                                                                 )
                                                                                                                     )
                                                                                                         )
                                                                                             )
                                                                                 )
                                                                             )
                                                                 );
    }

    public function Form() {
        return $this->Html()->BreadCrumbs() . HtmlTags::Section('.content')
                                                      ->Content(
                                                          HtmlTags::Div('.row')
                                                                  ->Content(
                                                                      HtmlTags::Div('.col-md-12')->Content(
                                                                          HtmlTags::Div('.card.card-primary.card-outline')
                                                                                  ->Content(
                                                                                      HtmlTags::Div('.card-header')
                                                                                              ->Content(
                                                                                                  $this->Html()->CardTitle(),
                                                                                                  $this->Html()->refreshAndBack()
                                                                                              ),
                                                                                      $this->Html()->FormStart() .
                                                                                      $this->Html()->FormGroupStart(4) .
                                                                                      $this->Html()->Label('نام شرکت') .
                                                                                      $this->Html()->Input('company_name') .
                                                                                      $this->Html()->FormGroupEnd() .

                                                                                      $this->Html()->FormGroupStart(4) .
                                                                                      $this->Html()->Label('لوگو') .
                                                                                      $this->Html()->ImageInput('company_logo', 'image/png', 150, 150) .
                                                                                      $this->Html()->FormGroupEnd() .

                                                                                      $this->Html()->FormGroupStart(4) .
                                                                                      $this->Html()->Label('تصویر هاور') .
                                                                                      $this->Html()->ImageInput('company_image', 'image/*', 150, 150,false,'company_image',false) .
                                                                                      $this->Html()->FormGroupEnd() .

                                                                                      $this->Html()->FormGroupStart(4) .
                                                                                      $this->Html()->Label('لینک') .
                                                                                      $this->Html()->Input('company_link','company_link','',false) .
                                                                                      $this->Html()->FormGroupEnd() .
                                                                                      $this->Html()->CardFooter()
                                                                                  )
                                                                      )
                                                                  )
                                                      );
    }

    public function addIndex(Document &$document) {
        $document->html = $this->Form();
    }

    public function editIndex(Document &$document) {
        $this->doFill();
        $document->html = $this->Form();
    }

    public function deleteIndex(Document &$document) {
        $this->doFill();
        $this->doDisableAll();
        $document->html = $this->Form();
    }

    public function viewIndex(Document &$document) {
        $this->doFill();
        $this->doDisableAll();
        $document->html = $this->Form();
    }

}
        