<?

namespace view;

use DOMWrap\Document;
use FwHtml\Elements\Tags\Main\HtmlTags;
use FwHtml\FontAwesome;
use View;

class Settings extends View
{

    public $SingularName = 'تنظیمات';

    public function main(Document &$document)
    {
        $document->html = $this->Html()->BreadCrumbs() . HtmlTags::Section('.content')
                ->Content(
                    HtmlTags::Div('.row')
                        ->Content(
                            HtmlTags::Div('.col-md-12')->Content(
                                HtmlTags::Div('.card.card-primary.card-outline')
                                    ->Content(
                                        HtmlTags::Div('.card-header')
                                            ->Content(
                                                $this->Html()->CardTitle(),
                                                $this->Html()->refreshAndAdd()
                                            ),
                                        HtmlTags::Div('.card-body.d-flex.flex-wrap')
                                            ->Content(
                                                HtmlTags::Table('.table.table-bordered.table-striped')
                                                    ->Content(
                                                        HtmlTags::Thead('.table-dark')
                                                            ->Content(
                                                                HtmlTags::Tr()->Content(
                                                                    HtmlTags::Th('ردیف')->Width('50'),
                                                                    HtmlTags::Th('شماره تماس'), HtmlTags::Th('آدرس ایمیل'), HtmlTags::Th('نسخه اندروید'),
                                                                    HtmlTags::Th('.no-sort عملیات')->Width('150')
                                                                )
                                                            ),
                                                        HtmlTags::Tbody()
                                                            ->Content(
                                                                $this->show(['setting_tel', 'setting_email', 'setting_android'])
                                                            )
                                                    )
                                            )
                                    )
                            )
                        )
                );
    }

    public function Form()
    {
        return $this->Html()->BreadCrumbs() . HtmlTags::Section('.content')
                ->Content(
                    HtmlTags::Div('.row')
                        ->Content(
                            HtmlTags::Div('.col-md-12')->Content(
                                HtmlTags::Div('.card.card-primary.card-outline')
                                    ->Content(
                                        HtmlTags::Div('.card-header')
                                            ->Content(
                                                $this->Html()->CardTitle(),
                                                $this->Html()->refresh()
                                            ),
                                        $this->Html()->FormStart() .
                                        $this->Html()->FormGroupStart(6) .
                                        $this->Html()->Label('شماره تماس') .
                                        $this->Html()->Tel('setting_tel') .
                                        $this->Html()->FormGroupEnd() .

                                        $this->Html()->FormGroupStart(6) .
                                        $this->Html()->Label('آدرس ایمیل') .
                                        $this->Html()->Email('setting_email') .
                                        $this->Html()->FormGroupEnd() .

                                        $this->Html()->FormGroupStart(6) .
                                        $this->Html()->Label('نسخه اندروید') .
                                        $this->Html()->Url('setting_android') .
                                        $this->Html()->FormGroupEnd() .

                                        $this->Html()->FormGroupStart(6) .
                                        $this->Html()->Label('نسخه IOS') .
                                        $this->Html()->Url('setting_ios') .
                                        $this->Html()->FormGroupEnd() .

                                        $this->Html()->FormGroupStart(6) .
                                        $this->Html()->Label('روزهای کاری') .
                                        $this->Html()->Input('working_days') .
                                        $this->Html()->FormGroupEnd() .

                                        $this->Html()->FormGroupStart(6) .
                                        $this->Html()->Label('ساعات کاری') .
                                        $this->Html()->Input('working_hours') .
                                        $this->Html()->FormGroupEnd() .

                                        $this->Html()->FormGroupStart(6) .
                                        $this->Html()->Label('درصد از مبلغ نهایی خریداری شده اشتراک به معرف کاربر') .
                                        $this->Html()->Percent('referral_reward_percent') .
                                        $this->Html()->FormGroupEnd() .

                                        $this->Html()->FormGroupStart(6) .
                                        $this->Html()->Label('حداقل مبلغ درخواست برداشت') .
                                        $this->Html()->Price('minimum_withdraw') .
                                        $this->Html()->FormGroupEnd() .

                                        $this->Html()->FormGroupStart(6) .
                                        $this->Html()->Label('عنوان فوتر') .
                                        $this->Html()->Input('footer_title') .
                                        $this->Html()->FormGroupEnd() .

                                        $this->Html()->FormGroupStart(6) .
                                        $this->Html()->Label('متن فوتر') .
                                        $this->Html()->TextArea('footer_text') .
                                        $this->Html()->FormGroupEnd() .

                                       $this->Html()->FormGroupStart(12) .
                                        $this->LicensesFormat().
                                        $this->Html()->FormGroupEnd() .

//                                        $this->Html()->FormGroupStart(6) .
//                                        $this->Html()->Label('آیکون مجوز') .
//                                        $this->Html()->ImageInput('license_icon1') .
//                                        $this->Html()->FormGroupEnd() .
//
//                                        $this->Html()->FormGroupStart(6) .
//                                        $this->Html()->Label('لینک مجوز') .
//                                        $this->Html()->Url('license_link1') .
//                                        $this->Html()->FormGroupEnd() .
//
//                                        $this->Html()->FormGroupStart(6) .
//                                        $this->Html()->Label('آیکون مجوز') .
//                                        $this->Html()->ImageInput('license_icon2') .
//                                        $this->Html()->FormGroupEnd() .
//
//                                        $this->Html()->FormGroupStart(6) .
//                                        $this->Html()->Label('لینک مجوز') .
//                                        $this->Html()->Url('license_link2') .
//                                        $this->Html()->FormGroupEnd() .
//
//                                        $this->Html()->FormGroupStart(6) .
//                                        $this->Html()->Label('آیکون مجوز') .
//                                        $this->Html()->ImageInput('license_icon3') .
//                                        $this->Html()->FormGroupEnd() .
//
//                                        $this->Html()->FormGroupStart(6) .
//                                        $this->Html()->Label('لینک مجوز') .
//                                        $this->Html()->Url('license_link3') .
//                                        $this->Html()->FormGroupEnd() .

                                        $this->Html()->CardFooter()
                                    )
                            )
                        )
                );
    }


    private function LicensesFormat()
    {
        return HtmlTags::Div('.card.card-info.card-outline.w-100')->Content(
            HtmlTags::Div('.card-header.p-3')->Content(
                HtmlTags::Span('.card-title.small')->Content(
                    HtmlTags::I()->Class(FontAwesome::Id_card_o())->Class('ml-2'),
                    "مجوز های فوتر"
                ),
                HtmlTags::Div('.card-tools#addLicenseBtn')->Content(
                    HtmlTags::Button('.btn.btn-success.p-2')->Content(
                        HtmlTags::I()->Class(FontAwesome::Plus())
                    )->Type("button"),
                ),
            ),
            HtmlTags::Div('.card-body.w-100.d-flex.flex-wrap.mt-3')->Content(
                $this->licenses(),
            )
        );

    }

    private function licenses()
    {
        $images = collect([]);

        $images = \model\Licenses::getAll();
        $this->initDataTable = false;

        return HtmlTags::Table('.table.table-bordered')->Content(
            HtmlTags::Thead()->Content(
                HtmlTags::Tr()->Content(
                    HtmlTags::Th()->Content("پیش ‌نمایش تصویر"),
                    HtmlTags::Th()->Content("لینک"),
                    HtmlTags::Th()->Content("عملیات")
                )
            ),
            HtmlTags::Tbody("#licenseTable")->Content(
                function () use ($images) {
                    return $images->map(function ($image, $index) {
                        $rowId = "license_row_" . uniqid();
                        $src = __IMAGES__."Licenses/".$image->license_icon;
                        return HtmlTags::Tr()->Id($rowId)->Content(
                            HtmlTags::Td()->Content(
                                "<img class='previewMe licenseIcon' alt='خطا در نمایش تصویر' src='$src' width='150' height='150'>"
                            ).
                            HtmlTags::Td()->Content(
                                HtmlTags::Input()
                                    ->Name("license_icons[$index][link]")
                                    ->Value($image->license_link)
                                    ->Class("form-control")
                                    ->Required()
                            ).
                            HtmlTags::Td()->Content(
                                HtmlTags::Button('.btn.btn-danger.p-2.deleteLicenseRow')->Content(
                                    HtmlTags::I()->Class(FontAwesome::Trash())
                                )->Data_('id', $rowId)->Data_('image',$image->license_icon)->Type('button')
                            ).
                            // hidden برای اینکه آدرس عکس فراموش نشه
                            HtmlTags::Input()
                                ->Type('hidden')
                                ->Name("license_images[$index][url]")
                                ->Value($image->license_icon)
                        );
                    })->join('');
                }
            ),
            HtmlTags::Tfoot()
        );
    }


    public function addIndex(Document &$document)
    {
        $document->html = $this->Form();
    }

    public function editIndex(Document &$document)
    {
        $this->doFill();
        $document->html = $this->Form();
    }

    public function deleteIndex(Document &$document)
    {
        $this->doFill();
        $this->doDisableAll();
        $document->html = $this->Form();
    }

    public function viewIndex(Document &$document)
    {
        $this->doFill();
        $this->doDisableAll();
        $document->html = $this->Form();
    }

}
        