<?

namespace view;

use DOMWrap\Document;
use FwHtml\Elements\Tags\Main\HtmlTags;
use View;

class Notifications extends View {

	public $SingularName = 'نوتیفیکیشن';

	public function main(Document &$document) {
		$document->html = $this->Html()->BreadCrumbs() . HtmlTags::Section('.content')
				->Content(
					HtmlTags::Div('.row')
						->Content(
							HtmlTags::Div('.col-md-12')->Content(
								HtmlTags::Div('.card.card-primary.card-outline')
									->Content(
										HtmlTags::Div('.card-header')
											->Content(
												$this->Html()->CardTitle(),
												$this->Html()->refreshAndAdd()
											),
										HtmlTags::Div('.card-body.d-flex.flex-wrap')
											->Content(
												HtmlTags::Table('.table.table-bordered.table-striped')
													->Content(
														HtmlTags::Thead('.table-dark')
															->Content(
																HtmlTags::Tr()->Content(
																	HtmlTags::Th('ردیف')->Width('50'),
																	HtmlTags::Th('تیتر'),
																	HtmlTags::Th('متن'),
																	HtmlTags::Th('تاریخ ارسال'),
																	HtmlTags::Th('.no-sort عملیات')->Width('150')
																)
															),
														HtmlTags::Tbody()
															->Content(
																$this->show([
																	'notification_title',
																	'notification_text',
																	'created_at' => function ($created) {
																		return jdate("Y/m/d H:i", strtotime($created));
																	}
																], true, false, false, true)
															)
													)
											)
									)
							)
						)
				);
	}

	public function addIndex(Document &$document) {
		$document->html = $this->Form();
	}

	public function Form() {
		return $this->Html()->BreadCrumbs() . HtmlTags::Section('.content')
				->Content(
					HtmlTags::Div('.row')
						->Content(
							HtmlTags::Div('.col-md-12')->Content(
								HtmlTags::Div('.card.card-primary.card-outline')
									->Content(
										HtmlTags::Div('.card-header')
											->Content(
												$this->Html()->CardTitle(),
												$this->Html()->refreshAndBack()
											),
										$this->Html()->FormStart() .
										$this->Html()->FormGroupStart(3) .
										$this->Html()->Label('تیتر') .
										$this->Html()->Input('notification_title') .
										$this->Html()->FormGroupEnd() .

										$this->Html()->FormGroupStart(9) .
										$this->Html()->Label('متن') .
										$this->Html()->TextArea('notification_text') .
										$this->Html()->FormGroupEnd() .

										$this->Html()->FormGroupStart(12) .
										$this->Html()->Label('کاربر ها') .
										$this->Html()->Select('user_id[]', 'user_id', HtmlTags::Option()->Value('all')->Content("همه کاربران") .
											\model\Users::toOption(false), true,false) .
										$this->Html()->FormGroupEnd() .

                                        $this->Html()->FormGroupStart(12) .
                                        $this->Html()->Label('پذیرندگان') .
                                        $this->Html()->Select('provider_id[]', 'provider_id', HtmlTags::Option()->Value('all')->Content("همه پذیرندگان") .
                                            \model\Providers::toOption(false), true,false) .
                                        $this->Html()->FormGroupEnd() .
										$this->Html()->CardFooter()
									)
							)
						)
				);
	}

	public function editIndex(Document &$document) {
		$this->doFill();
		$document->html = $this->Form();
	}

	public function deleteIndex(Document &$document) {
		$this->doFill();
		$this->doDisableAll();
		$document->html = $this->Form();
	}

	public function viewIndex(Document &$document) {
		$this->doFill();
		$this->doDisableAll();
		$document->html = $this->Form();
	}

}
        