<?

namespace view;

use DOMWrap\Document;
use FwHtml\Elements\Tags\Main\HtmlTags;
use FwHtml\FontAwesome;
use View;

class WithdrawRequests extends View
{

    public $SingularName = 'درخواست ';

    public function main(Document &$document)
    {
        $document->html = $this->Html()->BreadCrumbs() . HtmlTags::Section('.content')
                ->Content(
                    HtmlTags::Div('.row')
                        ->Content(
                            HtmlTags::Div('.col-md-12')->Content(
                                HtmlTags::Div('.card.card-primary.card-outline')
                                    ->Content(
                                        HtmlTags::Div('.card-header')
                                            ->Content(
                                                $this->Html()->CardTitle(),
                                                $this->Html()->refresh()
                                            ),
                                        HtmlTags::Div('.card-body.d-flex.flex-wrap')
                                            ->Content(
                                                HtmlTags::Table('.table.table-bordered.table-striped')
                                                    ->Content(
                                                        HtmlTags::Thead('.table-dark')
                                                            ->Content(
                                                                HtmlTags::Tr()->Content(
                                                                    HtmlTags::Th('ردیف')->Width('50'),
                                                                    HtmlTags::Th('کاربر'),
                                                                    HtmlTags::Th('مبلغ '),
                                                                    HtmlTags::Th('شماره شبا'),
                                                                    HtmlTags::Th('وضعیت'),
                                                                    HtmlTags::Th('توضیحات'),
                                                                    HtmlTags::Th('.no-sort عملیات')->Width('150')
                                                                )
                                                            ),
                                                        HtmlTags::Tbody()
                                                            ->Content(
                                                                $this->show([
                                                                    'user_id' => function ($id) {
                                                                        return show_user_name($id);
                                                                    },
                                                                    'price_format' => 'request_amount',
                                                                    'request_sheba',
                                                                    'request_status' => function ($status) {
                                                                        switch ($status) {
                                                                            case 0:
                                                                                return "در حال بررسی";
                                                                                break;
                                                                            case 1:
                                                                                return "واریز شده";
                                                                                break;
                                                                            case -1:
                                                                                return "رد شده";
                                                                                break;
                                                                            default:
                                                                                return "نامشخص";
                                                                                break;
                                                                        }
                                                                    },
                                                                    'request_note'
                                                                ],false,false,false,true,
                                                                    function ($row){
                                                                        if ($row->request_status == 0){
                                                                            return HtmlTags::A('.btn.btn-success.p-2.confirmRequest')->Content(
                                                                                    HtmlTags::I(".m-0.p-1")->Class(FontAwesome::Check()))
                                                                                    ->Data_('id', $row->withdraw_request_id)
                                                                                    ->Data_('toggle', 'tooltip')
                                                                                    ->Data_('placement', 'top')
                                                                                    ->Title('تایید پرداخت')." ";
                                                                        }

                                                                    },function ($row){
                                                                        if ($row->request_status == 0) {
                                                                            return HtmlTags::A('.btn.btn-danger.p-2.rejectRequest')->Content(
                                                                                HtmlTags::I(".m-0.p-1")->Class(FontAwesome::Times()))
                                                                                ->Data_('id', $row->withdraw_request_id)
                                                                                ->Data_('toggle', 'tooltip')
                                                                                ->Data_('placement', 'top')
                                                                                ->Title('رد کردن پرداخت');
                                                                        }

                                                                    }
                                                                )
                                                            )
                                                    )
                                            )
                                    )
                            )
                        )
                );
    }

    public function Form()
    {
        return $this->Html()->BreadCrumbs() . HtmlTags::Section('.content')
                ->Content(
                    HtmlTags::Div('.row')
                        ->Content(
                            HtmlTags::Div('.col-md-12')->Content(
                                HtmlTags::Div('.card.card-primary.card-outline')
                                    ->Content(
                                        HtmlTags::Div('.card-header')
                                            ->Content(
                                                $this->Html()->CardTitle(),
                                                $this->Html()->refreshAndBack()
                                            ),
                                        $this->Html()->FormStart() .
                                        $this->Html()->FormGroupStart(4) .
                                        $this->Html()->Label('انتخاب کاربر') .
                                        $this->Html()->Select('user_id', 'user_id', \model\Users::toOption()) .
                                        $this->Html()->FormGroupEnd() .

                                        $this->Html()->FormGroupStart(4) .
                                        $this->Html()->Label('مبلغ ') .
                                        $this->Html()->Input('request_amount') .
                                        $this->Html()->FormGroupEnd() .

                                        $this->Html()->FormGroupStart(4) .
                                        $this->Html()->Label('شماره شبا') .
                                        $this->Html()->Input('request_sheba') .
                                        $this->Html()->FormGroupEnd() .

                                        $this->Html()->CardFooter()
                                    )
                            )
                        )
                );
    }

    public function addIndex(Document &$document)
    {
        $document->html = $this->Form();
    }

    public function editIndex(Document &$document)
    {
        $this->doFill();
        $document->html = $this->Form();
    }

    public function deleteIndex(Document &$document)
    {
        $this->doFill();
        $this->doDisableAll();
        $document->html = $this->Form();
    }

    public function viewIndex(Document &$document)
    {
        $this->doFill();
        $this->doDisableAll();
        $document->html = $this->Form();
    }

}
        