<?php
// در بالای تمام فایل‌های API (یا در فایل مرکزی route)
header("Access-Control-Allow-Origin: " . $_SERVER['HTTP_ORIGIN']);
header("Access-Control-Allow-Headers: Content-Type, auth");
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");

// اگر متد OPTIONS بود، فقط با 200 پاسخ بده
if ($_SERVER['REQUEST_METHOD'] == 'OPTIONS') {
    http_response_code(200);
    exit();
}

use DATABASE\ORM\QueryBuilder\QueryBuilder\Db;
use FwRoutingSystem\Router;
use model\PaymentTable;
use site\helpers\ZarinPalPayment;

//ini_set('session.save_path', '/tmp');
ini_set('error_reporting', E_ALL);
ini_set('display_errors', E_ALL);
include '../admin/src/autoload.php';
const __API__ = __DIR__ . '/routes/';
define("__HOST__", "https://api." . str(FwConfig::HOST())->explode('/')[0]);
const __IMAGES__ = 'https://anikart.lexaplus.ir/admin/src/images/';
const __FILES__ = __IMAGES__ . 'Files/';
$Router = new Router();
Db::table('tblApiRequests')->insert([
	'ip'      => getIp(),
	'route'   => $_SERVER['REQUEST_URI'],
	'headers' => json_encode(getallheaders()),
	'body'    => json_encode([
		'input' => file_get_contents('php://input') ?? [],
		'post'  => $_POST,
		'get'   => $_GET,
	]),

]);

$Router->any('/callback', function () {
    header("Content-Type: text/html");

    $debug = false;


    $Authority = $_GET['Authority'];
    $Payment = new ZarinPalPayment();
    $Payment->initPayment(new PaymentTable());
    [
        $paymentData,
        $paymentResult
    ] = $Payment->getResult($Authority);
    $paymentId = $paymentData->payment_id;
    $amount = $paymentData->payment_amount;
    $from = $paymentData->payment_from;
    $callBackUrl = "anikakart.com/anikart/result";
    $http = "https";
    if ($debug){
        $http = "http";
        $callBackUrl = "localhost:3000/anikart/result";
    }
    $callback = $from == 'site' ? "$http://$callBackUrl/$Authority" : "app://$callBackUrl/$Authority";
    $callbackText = $from == 'site' ? "بازگشت به سایت" : "بازگشت به اپ";
    if (isset($paymentResult) and isset($paymentResult['data']) and isset($paymentResult['data']['code']) and $paymentResult['data']['code'] == 100) {
        $Payment->update($_GET['Authority'], $_GET['Authority']);
        include __BASE_DIR__ . '/callback-success.php';
    } else {
        include __BASE_DIR__ . '/callback-fail.php';
    }
});
$Router->get('/qrcode', function () {
	include 'qrcode.php';
});
header('Content-Type: application/json');
const global_error = "Unknown error!";
http_response_code(500);

function response($content, $statusCode = 200) {
	http_response_code($statusCode);
	return is_iterable($content) ? json_encode($content, JSON_UNESCAPED_UNICODE) : $content;
}


$Router->any('/', function () {
	return response([], 404);
});
$Router->any('/main/index', function () {
	return response([], 404);
});

$Router->use(\version\ApiVersions::version(\version\ApiVersions::one, [
	\routes\v1\AuthRoute::class,
	\routes\v1\MainRoute::class,
	\routes\v1\ProviderRoute::class,
	\routes\v1\PagesRoute::class,
	\routes\v1\ClubRoute::class,
]));


$Router->error(function () {
	echo response(['message' => 'endpoint not found'], 404);
});
$Router->any(':all/:all?/:all?/:all?/:all?/:all?', function () {
	return response(['message' => 'endpoint not found'], 404);
});
