<?php

namespace routes\v1;

use Api\BaseRouter;
use FwRoutingSystem\Router;
use model\Entity\MembershipsEntity;
use model\Entity\PlansEntity;
use model\Entity\PointsEntity;
use model\Entity\RewardCategoriesEntity;
use model\Entity\RewardsEntity;
use model\Entity\ScoresEntity;
use model\Entity\UsersEntity;
use model\Plans;
use model\Points;
use model\RewardCategories;
use model\Rewards;
use model\Scores;
use model\Users;
use version\ApiVersions;

class  ClubRoute extends BaseRouter {

    public string $version = ApiVersions::one;
    public $groupPath = 'club';

    public function routes(Router $router) {
        $router->get('/history',$this->middleware($router),function (){
            $user = Users::findToken(get_header('auth'));

            return response(Points::Db()->where('user_id', $user->user_id)->orderBy('created_at',true)->get()->map(function (PointsEntity $point) {
                return $point->apiFormat();
            }));
        });
        $router->any('/home', $this->middleware($router), function () {
            $user = Users::findToken(get_header('auth'));

            if (!($user instanceof UsersEntity)) {
                return response(['message' => 'کاربر یافت نشد'], 404);
            }

            // --- 1. ماموریت‌ها
            $scores = Scores::Db()->get()->map(function (ScoresEntity $score) {
                return $score->apiFormat();
            })->values();

            // --- 2. ماموریت‌های انجام‌شده
            $userPoints = Points::Db()->where('user_id', $user->user_id)->where('point_type',0)->orderBy('created_at',true)->limit(2)->get()->map(function (PointsEntity $point) {
                return $point->apiFormat();
            });

            // --- streak calculation (no Carbon)
            $dailyScoreId = 3;
            $points = Points::Db()
                            ->where('user_id', $user->user_id)
                            ->where('score_id', $dailyScoreId)
                            ->orderBy('created_at', 'desc')
                            ->get();

            $streak = 0;
            $todayStart = date('Y-m-d') . ' 00:00:00';
            $todayEnd   = date('Y-m-d') . ' 23:59:59';

            $hasToday = Points::Db()
                              ->where('user_id', $user->user_id)
                              ->where('score_id', $dailyScoreId) // معمولاً 3
                              ->where('created_at', '>=', $todayStart)
                              ->where('created_at', '<=', $todayEnd)
                              ->rowCount() > 0;
            $expectedDate = $hasToday
                ? strtotime(date('Y-m-d')) // اگر امروز گرفته، از امروز شروع کنیم
                : strtotime('-1 day', strtotime(date('Y-m-d'))); // اگر نگرفته، از دیروز شروع کنیم

            foreach ($points as $point) {
                $createdAtTimestamp = strtotime($point->created_at);

                // بازه‌ای که انتظار داریم امتیازش در اون تاریخ باشه
                $startOfExpectedDay = strtotime(date('Y-m-d 00:00:00', $expectedDate));
                $endOfExpectedDay   = strtotime(date('Y-m-d 23:59:59', $expectedDate));

                if ($createdAtTimestamp >= $startOfExpectedDay && $createdAtTimestamp <= $endOfExpectedDay) {
                    $streak++;
                    $expectedDate = strtotime('-1 day', $expectedDate); // برو به روز قبل
                } else {
                    break; // streak شکست
                }
            }


            $hasToday = false;
            foreach ($points as $point) {
                if (date('Y-m-d', strtotime($point->created_at)) === date('Y-m-d')) {
                    $hasToday = true;
                    break;
                }
            }

            $dailyPoints = \model\DailyPoints::Db()->get();
            $rewardTable = [];
            foreach ($dailyPoints as $dailyPoint) {
                $rewardTable[] = $dailyPoint->point;
            }

            // اگر امروز نگرفته، پس باید جای "امروز" بیاد بعد از آخرین روز گرفته‌شده
            $claimedDays = $hasToday ? $streak : $streak;
            $displayLength = $hasToday ? $streak : $streak + 1;

            $streakProgress = [];

            for ($i = 0; $i < 7; $i++) {
                $streakProgress[] = [
                    'day'     => $i + 1,
                    'points'  => $rewardTable[$i],
                    'claimed' => $i < $claimedDays,
                    'isToday' => $i === $claimedDays && !$hasToday, // فقط زمانی که امروز نگرفته
                ];
            }



            return response([
                                'streak'         => $streak,
                                'todayClaimed'   => $hasToday,
                                'scores'         => $scores,
                                'userPoints'     => $userPoints,
                                'streakProgress' => $streakProgress,

                            ]);
        });
        $router->post('/claim-daily', $this->middleware($router), function () {
            $user = Users::findToken(get_header('auth'));
            if (!($user instanceof UsersEntity)) {
                return response(['message' => 'کاربر یافت نشد'], 404);
            }

            $scoreId = 3;
            $todayStart = date('Y-m-d') . ' 00:00:00';
            $todayEnd = date('Y-m-d') . ' 23:59:59';

            $alreadyClaimed = Points::Db()
                                    ->where('user_id', $user->user_id)
                                    ->where('score_id', $scoreId)
                                    ->where('created_at', '>=', $todayStart)
                                    ->where('created_at', '<=', $todayEnd)
                                    ->rowCount() > 0;

            if ($alreadyClaimed) {
                return response(['message' => 'امتیاز امروز قبلاً دریافت شده است.'], 400);
            }

            // محاسبه streak
            $points = Points::Db()
                            ->where('user_id', $user->user_id)
                            ->where('score_id', $scoreId)
                            ->orderBy('created_at', true)
                            ->get();

            $streak = 0;
            $expectedDate = strtotime("-1 day");

            foreach ($points as $point) {
                $pointDate = date('Y-m-d', strtotime($point->created_at));
                if ($pointDate === date('Y-m-d', $expectedDate)) {
                    $streak++;
                    $expectedDate = strtotime('-1 day', $expectedDate);
                } else {
                    break;
                }
            }

            // خواندن امتیاز واقعی از جدول daily_points
            $dailyPoints = \model\DailyPoints::Db()->get()->sortBy(function ($row) {
                return (int) $row->day;
            })->values();

            $earnedPoint = 1; // مقدار پیش‌فرض اگر هیچ رکوردی پیدا نشد

            if ($streak < $dailyPoints->length()) {
                $earnedPoint = $dailyPoints->get($streak)->point;
            } else {
                $earnedPoint = $dailyPoints->last()->point;
            }

            Points::Db()->insert([
                                     'user_id'     => $user->user_id,
                                     'score_id'    => $scoreId,
                                     'point_score' => $earnedPoint,
                                     'point_cause' => "امتیاز روزانه",
                                     'created_at'  => date('Y-m-d H:i:s'),
                                 ]);

            Users::edit($user->user_id, [
                'user_score' => $user->score + $earnedPoint,
            ]);

            return response([
                                'message' => "امتیاز امروز با موفقیت ثبت شد.",
                                'earned'  => $earnedPoint,
                                'total'   => $user->score + $earnedPoint,
                                'streak'  => $streak + 1,
                            ]);
        });
        $router->get('/rewards', $this->middleware($router), function () {
            $rewards = Rewards::Db()->get()->map(function (RewardsEntity $reward) {
                return $reward->apiFormat();
            });
            return response($rewards);
        });
        $router->post('/buy', $this->middleware($router), function () {
            $reward = $this->getParam('reward');
            $user = Users::findToken(get_header('auth'));

            $reward = Rewards::get($reward);
            if ($reward instanceof RewardsEntity) {
                $neededPoints = $reward->required_points;
                $currentPoints = $user->score;
                if ($currentPoints >= $neededPoints) {
                    if (Points::buy($user, $reward)) {
                        switch ($reward->category_id) {
                            case 3:
                                $user = Users::get($user->user_id);
                                $meta = json_decode($reward->meta);
                                return response([
                                                    'user'         => $user->apiFormat(),
                                                    'type'         => 'discount',
                                                    'discount'     => $meta->discount,
                                                    'discountCode' => "FRIWUEC",
                                                    'message'      => "کد تخفیف $meta->discount برای برای شما فعال شد.",

                                                ]);
                            case 4:
                                $meta = json_decode($reward->meta, true);
                                $value = price_format($meta['help']);
                                $user = Users::get($user->user_id);
                                return response([
                                                    'user'    => $user->apiFormat(),
                                                    'type'    => 'charity',
                                                    'help'    => $value,
                                                    'charity' => "بنیاد خیریه بنک دار",
                                                    'message' => "مبلغ $value به بنیاد خیریه بنک دار اهدا شد.",
                                                ]);
                            case 1:
                                $meta = json_decode($reward->meta, true);
                                $plan = Plans::Db()->where('plan_duration', '=', @$meta['days'])->get()->first;
                                if ($plan instanceof PlansEntity) {
                                    $duration = $plan->duration;
                                    Users::edit($user->user_id, [
                                        'plan_id'           => $plan->plan_id,
                                        'plan_activated_at' => time(),
                                        'plan_expired_at'   => strtotime("+$duration days", time()),
                                    ]);
                                    $user = Users::get($user->user_id);
                                    return response([
                                                        'user'    => $user->apiFormat(),
                                                        'message' => "اشتراک $plan->name برای شما فعال شد.",
                                                    ]);
                                }
                        }
                        return response([
                                            'message' => "خطایی رخ داد"
                                        ], 400);
                    }
                    return response([
                                        'message' => "خطایی در ثبت امتیاز رخ داد"
                                    ], 403);
                }
                return response([
                                    'currentPoints' => $currentPoints,
                                    'message'       => "موجودی امتیاز شما کافی نمی باشد"
                                ], 403);
            }
            return response([
                                'message' => "جایزه یافت نشد"
                            ], 404);
        });

    }

    public function requiredHeaders(): array {
        return [];
    }

}