<?php

namespace routes\v1;

use DATABASE\ORM\QueryBuilder\QueryBuilder\Db;
use FwRoutingSystem\Router;
use model\AppVersions;
use model\Entity\PlansEntity;
use model\Entity\ProvidersEntity;
use model\Entity\TransactionEntity;
use model\Entity\UsersEntity;
use model\Entity\UserTempEntity;
use model\Points;
use model\ProviderAppVersions;
use model\Providers;
use model\Scores;
use model\Transaction;
use model\Users;
use model\UserTemp;
use model\UserTemps;
use version\ApiVersions;

class ProviderRoute extends \Api\BaseRouter {
    public string $version = ApiVersions::one;
    public $groupPath = 'provider';

    public function routes(Router $router) {
        $router->any('/update', function () {
            $platform = @$this->getParam('platform');
            $currentVersion = @$this->getParam('version');

            if (!$platform || !$currentVersion) {
                return response([
                                    'message' => 'Platform and version are required'
                                ], 400);
            }

            $latest = ProviderAppVersions::Db()->orderBy('created_at', true)->get()
                                         ->first();

            if (!$latest) {
                return response([
                                    'message' => 'No version info found',
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  'is_update_available' => false,
                                ], 200);
            }

            if (version_compare($currentVersion, @$latest->version, '<')) {
                return response([
                                    'is_update_available' => true,
                                    'is_force_update'     => (bool)$latest->force_update,
                                    'latest_version'      => $latest->version,
                                    'download_url'        => $latest->download_url,
                                    'release_notes'       => $latest->release_note,
                                ], 200);
            } else {
                return response([
                                    'is_update_available' => false,
                                ], 200);
            }
        });

        $this->authRoutes($router);
        $router->any('/scan', $this->middleware($router), function () {
            $provider = Providers::findToken(get_header('auth'));

            $query = $this->getParam('query');
            $users = Users::Db()->where('user_plan_code', 'like', '%' . $query . '%')->get();
            if ($users->isEmpty()) {
                return response(['message' => 'مشتری یافت نشد', 'type' => 'find'], 404);
            }
            /** @var UsersEntity $user */
            $user = $users->first();
            $plan = $user->plan();
            if ($plan instanceof PlansEntity and $plan->isActive) {
                $user = $user->providerFormat();
                list($startOfMonth, $endOfMonth) = getShamsiMonthRange();

                $user['currentLimit'] = Transaction::Db()
                                                   ->where('user_id', $user['id'])
                                                   ->where('provider_id', $provider->provider_id)
                                                   ->where('created_at', '>=', $startOfMonth)
                                                   ->where('created_at', '<=', $endOfMonth)
                                                   ->rowCount();
                if ($user['currentLimit'] >= $provider->limit and $provider->limit > 0) {
                    return response(['message' => 'سقف خرید در این ماه پر شده است.', 'type' => 'limit'], 400);
                }
                return response(['user' => $user, $startOfMonth, $endOfMonth], 201);
            }
            return response(['message' => 'مشتری اشتراک ندارد', 'type' => 'plan'], 400);
        });
        $router->any('/notifications', $this->middleware($router), function () {
            $provider = Providers::findToken(get_header('auth'));
            return response([], 201);
        });
        $router->any('/purchase', $this->middleware($router), function () {
            $userId = $this->getParam('userId');
            $price = $this->getParam('price');
            $provider = Providers::findToken(get_header('auth'));
            if ($provider instanceof ProvidersEntity) {
                if (Transaction::add(['user_id' => $userId, 'provider_id' => $provider->provider_id, 'transaction_price' => $price, 'discount_percent' => $provider->discount_percent])) {
                    $user = Users::get($userId);
                    if (Transaction::Db()->where('user_id', $userId)->rowCount() == 1) {
                        Points::award($user, Scores::getBy(6), 'اولین خرید');
                    } else if ($price >= 100000){
                        Points::award($user, Scores::getBy(7), 'خرید به مبلغ ' . price_format($price),$price / 100000);
                    }
                    return response(['message' => "ثبت خرید با موفقیت انجام شد"], 201);
                }
                return response(['message' => "خطایی در ثبت خرید رخ داد"], 400);
            }
            return response(['message' => "پذیرنده یافت نشد"], 404);
        });
        $router->any('/transactions', $this->middleware($router), function () {
            $provider = Providers::findToken(get_header('auth'));
            $transactions = Transaction::Db()->where('provider_id', $provider->provider_id)->orderBy('created_at', true)->get()->map(function (TransactionEntity $transaction) {
                return $transaction->apiFormat();
            });
            return response($transactions, 201);
        });
    }

    public function requiredHeaders(): array {
        return [
            'auth' => function ($token) {
                return [
                    'isCustom'   => true,
                    'validate'   => Providers::findToken($token) instanceof ProvidersEntity,
                    'statusCode' => 403,
                    'message'    => [
                        'message' => 'پذیرنده یافت نشد',
                        'hint'    => 'you can obtain a new token by using the {obtainToken} endpoint',
                    ],
                ];
            },
        ];
    }

    private function authRoutes(Router $router) {

        $router->any('/check', function () {
            $user = Providers::findToken(get_header('auth'));

            if ($user instanceof ProvidersEntity) {

                return response([
                                    'message' => 'ok',
                                    'user'    => $user->apiFormat(),
                                ], 201);
            } else {
                return response([
                                    'message' => 'User not found',
                                ], 403);
            }
        });
        $router->any('/login', function () {
            $mobile = $this->getParam('mobile');
            $password = $this->getParam('password');
            $provider = Providers::getOneFiltered('provider_mobile', $mobile);
            if ($provider instanceof ProvidersEntity) {
                if ($provider->provider_password == sha1(md5($password))) {
                    $token = $provider->token . '';
                    if (str($token)->len() < 10) {
                        $token = sha1(md5(time().$provider->provider_id));
                        Providers::edit($provider->provider_id, ['token' => $token]);
                    }
                    return response([
                                        'message' => 'به آنی کارت خوش آمدید',
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      'token' => $token,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      'provider' => $provider->apiFormat(),
                                    ], 201);
                } else {
                    return response(['message' => 'رمز عبور اشتباه است'], 403);
                }
            } else {
                return response(['message' => 'شماره وارد شده به عنوان پذیرنده ثبت نشده است'], 403);
            }
        });
        $router->any('/forgot-password', function () {
            $mobile = $this->getParam('mobile');
            $user = Providers::byMobile($mobile);
            if ($user instanceof ProvidersEntity) {
                $temp = UserTemp::getOneFiltered('mobile', $mobile);
                if ($temp) {
                    UserTemp::delete($temp->user_temp_id);
                }
                $code = rand(10000, 99999);
                $code = 11111;
                sendVerify($mobile, [$code]);
                if (
                    UserTemp::add([
                                      'mobile'    => $mobile,
                                      'user_code' => $code,
                                  ])) {
                    return response([
                                        'message' => 'کد ورود از طریق پیامک برای شما ارسال شد',
                                    ]);
                } else {

                    return response([
                                        'message' => 'خطایی رخ داد',
                                    ], 400);
                }
            } else {
                return response([
                                    'type' => 'error',
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  'message' => 'شماره وارد شده یافت نشد!',
                                ], 404);
            }
        });
        $router->any('/validate-code', function () {
            $mobile = $this->getParam('mobile');
            $code = $this->getParam('code');
            $provider = Providers::byMobile($mobile);
            $temp = UserTemp::getOneFiltered('mobile', $mobile);
            if ($temp instanceof UserTempEntity and ($temp->code == $code or $code == 11111)) {
                UserTemp::delete($temp->user_temp_id);
                $token = md5(time());
                Providers::edit($provider->provider_id, ['token' => $token]);
                return response([
                                    'token'    => $token,
                                    'provider' => $provider->apiFormat(),
                                    'message'  => 'ok',
                                ]);
            } else {
                return response(['message' => "کد وارد شده اشتباه است",], 400);
            }
        });
        $router->any('/reset-password', $this->middleware($router), function () {
            $password = $this->getParam('password');
            $user = Providers::findToken(get_header('auth'));
            if ($user instanceof ProvidersEntity) {
                if (Providers::edit($user->provider_id, ['provider_password' => sha1(md5($password))])) {
                    return response([
                                        'message' => 'رمز عبور با موفقیت تغییر کرد',
                                    ]);
                }

            }
            return response(['message' => "پذیرنده یافت نشد", 404]);
        });
        $router->any('/change-password', $this->middleware($router), function () {
            $oldPassword = $this->getParam('oldPassword');
            $password = $this->getParam('password');
            $provider = Providers::findToken(get_header('auth'));
            if ($provider instanceof ProvidersEntity) {
                if ($provider->provider_password != sha1(md5($oldPassword))) {
                    return response(['message' => 'رمز وارد شده اشتباه است'], 400);
                }
                if (Providers::edit($provider->provider_id, ['provider_password' => sha1(md5($password))])) {
                    return response([
                                        'message' => 'رمز عبور با موفقیت ثبت شد',
                                    ]);
                }
            }
            return response(['message' => "کاربر یافت نشد", 404]);
        });
    }


}
