<?php

namespace controller;

use ControllerScheme;

class Codes extends ControllerScheme
{
    const name = 'کد';

    protected function add(?bool $csrf = true)
    {
        $type = $this->requestArray()['aniCodeType'];
        $plan_id = $this->requestArray()['plan_id'];
        if ($type == "random") {
            $number = $this->requestArray()['codeNumber'];
            $codes = [];

            for ($i = 0; $i < $number; $i++) {
                do {
                    $code = generateRandomString(6, false);
                } while (\model\Codes::getOneFiltered('code', $code));
                \model\Codes::add([
                    'code' => $code,
                    'plan_id' => $plan_id,
                ]);
                $codes[] = $code;

            }
            $dir = __SOURCE__ . 'images/Codes/';
            $filename = 'generated_codes_' . time() . '.txt';
            $filepath = $dir . $filename;
            if (file_put_contents($filepath, implode("\n", $codes))) {
                $link = __IMAGES__ . 'Codes/' . $filename;
            } else {
                $link = "";
            }

            return showSuccessMsgWithButton('کد', 'افزودن', $link);


        } elseif ($type == "custom") {
            $code = $this->requestArray()['codeNumber'];
            if (strlen($code) !== 6) {
                return showErrorMsg('کد', 'افزودن', 'طول کد وارد شده باید دقیقاً ۶ کاراکتر باشد');
            }
            $check = \model\Codes::getOneFilteredCaseSensitive('code', $code);
            if ($check) {
                return showErrorMsg('کد', 'افزودن', 'کد وارد شده قبلا ثبت شده و تکراری است');
            } else {
                \model\Codes::add([
                    'code' => $code,
                    'plan_id' => $plan_id,
                ]);
                return showSuccessMsg('کد', 'افزودن');
            }
        }
    }


    public function Inperson()
    {
        return $this->view($this->viewName(), 'Inperson', [
        ]);
    }

    public function submitInperson()
    {
        $codes = $_POST['codes'] ?? [];
        $globalReferral = $_POST['global_referral_code'] ?? null;

        $i = 0;
        foreach ($codes as $codeRow) {
            $code = $codeRow['code'];
            $planId = (int)$codeRow['plan_id'];
            $expireDateStr = $codeRow['expire_date'];
            $referralCode = trim($codeRow['referral_code'] ?: $globalReferral);

            // تبدیل تاریخ
            $expireTimestamp = persianStrToTime($expireDateStr);

            // بررسی referral
            $user = null;
            if ($referralCode) {
                $user = \model\Users::get_by_referral($referralCode);
            }

            // ثبت در tblCodes
            if (
                \model\Codes::add([
                    'code' => $code,
                    'plan_id' => $planId,
                    'is_reserved' => 1,
                    'referrer_id' => $user ? $user->user_id : 0,
                    'expire_at' => date('Y-m-d H:i:s', $expireTimestamp),
                ])) {
                $i++;
            }


        }
        return showSuccessMsg($i . ' کد رزرو', 'ذخیره');


    }

}