<?php

namespace controller;

use model\Folders;
use ControllerScheme;
use model\Entity\FilesEntity;
use model\Entity\FoldersEntity;
use FwHtml\Elements\Tags\Main\HtmlTags;

class Files extends ControllerScheme {
    const name = 'فایل';

    public static $__uploads = ["file_path" => __SOURCE__ . "images/Files/"];

    public function main() {
        $folderId = $this->requestArray('folderId') ?? 0;
        return $this->view($this->viewName(), 'main', [
            collect([
                ...Folders::getAllFiltered('parent_id', $folderId),
                ...$this->model()::getAllFiltered('folder_id', $folderId),
            ]),
        ]);
    }

    public function deleteFile() {
        $ids = json_decode($this->requestArray('ids'), true);
        foreach ($ids as $id) {
            \model\Files::delete($id);
        }
        return 1;
    }

    public function deleteFolder() {
        $id = $this->requestArray('id');
        $delete = \model\Folders::delete($id);
        if ($delete) {
            return 1;
        }
        return 0;
    }
    public function addFolder() {
        $parent_id = $this->requestArray('parentId')?:0;
        if (Folders::add([
            'folder_name' => $this->requestArray('name'),
            'parent_id'   => $parent_id,
        ])) {
            return 1;
        }
        return 0;
    }

    public function filePicker() {
        $options = $this->requestArray('options');
        $folderId = $this->requestArray('folderId');
        if (!isset($folderId)) {
            $folderId = $_SESSION['folderId'] ?? 0;
        }
        $db = $this->model()::Db()->where('folder_id', $folderId)->get()->filter(function (FilesEntity $file) use ($options) {
            if (is_array($options)) {
                foreach ($options as $option) {
                    if (str($file->path)->endsWith($option)) {
                        return true;
                    }
                }
                return false;
            } else {
                return true;
            }
        });
        $data = collect([
            ...Folders::getAllFiltered('parent_id', $folderId),
            ...$db,
        ]);
        return $this->files($data);
    }

    private function files($data) {
        return HtmlTags::Div('.file-manager-container.file-manager-col-view')->Content(
            $data->map(function ($file) {
                return $this->buildFile($file);
            })->values()->join('')
        );
    }

    private function buildFile($file) {
        $isFolder = $file instanceof FoldersEntity;
        return HtmlTags::Div(".file-item" . ($isFolder ? ".fileManagerFolder" : ".fileManagerFile"))->Data_('name', $file->name())->Data_('id', $file->id())->Content(
            HtmlTags::Div('.file-item-select-bg.bg-primary'),
            HtmlTags::Div('.file-item-img')->Content(
                $file->thumb()
            ),
            HtmlTags::A('.file-item-name')->Href('javascript:void(0)')->Content(
                $file->name()
            )
        );
    }
}
