"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = _default;
exports.sassConditionalBraceNLAfterChecker = sassConditionalBraceNLAfterChecker;
exports.messages = exports.ruleName = void 0;

var _utils = require("../../utils");

var _stylelint = require("stylelint");

var _lodash = _interopRequireDefault(require("lodash.isboolean"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

var ruleName = (0, _utils.namespace)("at-if-closing-brace-newline-after");
exports.ruleName = ruleName;

var messages = _stylelint.utils.ruleMessages(ruleName, {
  expected: 'Expected newline after "}" of @if statement',
  rejected: 'Unexpected newline after "}" of @if statement'
});

exports.messages = messages;

function _default(expectation, options, context) {
  return function (root, result) {
    var validOptions = _stylelint.utils.validateOptions(result, ruleName, {
      actual: expectation,
      possible: ["always-last-in-chain"]
    }, {
      actual: options,
      possible: {
        disableFix: _lodash["default"]
      },
      optional: true
    });

    if (!validOptions) {
      return;
    }

    sassConditionalBraceNLAfterChecker({
      root: root,
      result: result,
      ruleName: ruleName,
      atRuleName: "if",
      expectation: expectation,
      messages: messages,
      context: context,
      options: options
    });
  };
}
/**
 * The core logic for this rule. Can be imported by other rules with similar
 * logic, namely at-else-closing-brace-newline-after
 *
 * @param {Object} args -- Named arguments object
 * @param {PostCSS root} args.root
 * @param {PostCSS result} args.result
 * @param {String ruleName} args.ruleName - needed for `report` function
 * @param {String} args.atRuleName - the name of the at-rule to be checked, e.g. "if", "else"
 * @param {Object} args.messages - returned by stylelint.utils.ruleMessages
 * @return {undefined}
 */


function sassConditionalBraceNLAfterChecker(_ref) {
  var root = _ref.root,
      result = _ref.result,
      ruleName = _ref.ruleName,
      atRuleName = _ref.atRuleName,
      expectation = _ref.expectation,
      messages = _ref.messages,
      context = _ref.context,
      options = _ref.options;
  var shouldFix = context.fix && (!options || options.disableFix !== true);

  function complain(node, message, index, fixValue) {
    if (shouldFix) {
      node.next().raws.before = fixValue;
      return;
    }

    _stylelint.utils.report({
      result: result,
      ruleName: ruleName,
      node: node,
      message: message,
      index: index
    });
  }

  root.walkAtRules(function (atrule) {
    // Do nothing if it's not an @if
    if (atrule.name !== atRuleName) {
      return;
    }

    var nextNode = atrule.next();

    if (!nextNode) {
      return;
    }

    var nextBefore = nextNode.raws.before;
    var hasNewLinesBeforeNext = nextBefore && !(0, _utils.isSingleLineString)(nextBefore);
    var reportIndex = atrule.toString().length;

    if (expectation === "always-last-in-chain") {
      // If followed by @else, no newline is needed
      if (nextNode.type === "atrule" && (nextNode.name === "else" || nextNode.name === "elseif")) {
        if (hasNewLinesBeforeNext) {
          complain(atrule, messages.rejected, reportIndex, " ");
        }
      } else {
        if (!hasNewLinesBeforeNext) {
          complain(atrule, messages.expected, reportIndex, context.newline);
        }
      }
    }
  });
}