<?php

if (!class_exists('SmsHelper')) {
    class SmsHelper {
        private static $token = 'your-token-here';
        private static $from = '+983000505';
        private static $baseUrl = 'https://ippanel.com/api/send';

        private static function send($patternCode, $phoneNumber, array $params = []): array {
            return sendSmsPattern($phoneNumber, $patternCode, $params);
        }

        // 1. ثبت‌نام
        public static function sendSignupCode($phone, $code) {
            return self::send('bcke0jajnnd8xjk', $phone, ['verification-code' => $code]);
        }

        // 2. فراموشی رمز عبور
        public static function sendForgotPasswordCode($phone, $code) {
            return self::send('2dj8aqz8qpkvam7', $phone, ['verification-code' => $code]);
        }

        // 3. تغییر رمز عبور
        public static function sendPasswordChanged($phone) {
            return self::send('hz9vlsw8rp1mmy7', $phone);
        }

        // 4. خرید موفق اشتراک
        public static function sendSubscriptionSuccess($phone, $plan, $date, $time) {
            return self::send('53na3jlwm8z8fsy', $phone, [
                'plan' => $plan,
                'date' => $date,
                'time' => $time
            ]);
        }

        // 5. خرید ناموفق اشتراک
        public static function sendSubscriptionFailed($phone) {
            return self::send('hbvr2m3bl8256np', $phone, []);
        }

        // 6. درخواست احراز هویت
        public static function sendIdentityRequested($phone) {
            return self::send('dikz8sgnh0cgf06', $phone, []);
        }

        // 7. تایید احراز هویت
        public static function sendIdentityApproved($phone, $name, $price, $code) {
            return self::send('gt0f2modfmyefkj', $phone, [
                'name'           => $name,
                'price'          => $price,
                'affiliate_code' => $code
            ]);
        }

        // 8. رد احراز هویت
        public static function sendIdentityRejected($phone, $reason) {
            return self::send('uie67fc3a47p2bm', $phone, [
                'reason' => $reason
            ]);
        }

        // 9. خرید از پذیرنده
        public static function sendVendorPurchase($phone, $name, $vendor) {
            return self::send('pisgyrdmxy9luyw', $phone, [
                'name'   => $name,
                'vendor' => $vendor
            ]);
        }

        // 10. درخواست برداشت وجه
        public static function sendWithdrawRequested($phone, $name) {
            return self::send('rataxyyihaod09c', $phone, [
                'name' => $name
            ]);
        }

        // 11. تایید برداشت وجه
        public static function sendWithdrawApproved($phone, $fname) {
            return self::send('x3cmbse4iqd8fr', $phone, [
                'fname' => $fname
            ]);
        }

        // 12. رد برداشت وجه
        public static function sendWithdrawRejected($phone, $name, $reason) {
            return self::send('m5u1g7vpptz0tn9', $phone, [
                'name'   => $name,
                'reason' => $reason
            ]);
        }

        // 13. افزودن امتیاز دستی
        public static function sendManualPointAdded($phone, $name, $reason) {
            return self::send('e1ep929schf2j12', $phone, [
                'name'   => $name,
                'reason' => $reason
            ]);
        }

        // 14. معرفی دیگران
        public static function sendReferralReward($phone, $name, $price, $affiliateCode) {
            return self::send('hth1bp9fjlrcce3', $phone, [
                'name'           => $name,
                'price'          => $price,
                'affiliate_code' => $affiliateCode
            ]);
        }

        // 15. تبریک تولد
        public static function sendBirthdayCongrats($phone, $name) {
            return self::send('7pqpg1xzvgr7szd', $phone, [
                'name' => $name
            ]);
        }
    }
}
