<?php

namespace FwHtml\Elements\Attrs;

use FwHtml\Elements\Attrs\Props\Props;

class Style {
	private $arrayOfStyles = [];
	
	/**
	 * Style constructor.
	 *
	 * @param array $styles
	 */
	public function __construct(array $styles) {
		foreach ($styles as $style) {
			if ($style instanceof Props) {
				$this->addStyle($style::name, $style::$value);
			}
		}
	}
	
	/**
	 * @param string $name
	 * @param string $value
	 */
	protected function addStyle(string $name, string $value) {
		$this->arrayOfStyles[$name] = $value;
	}
	
	public static function raw(array $array) {
		$style = new Style([]);
		foreach ($array as $key => $value) {
			$style->addStyle($key, $value);
		}
		return $style;
	}
	
	/**
	 * @return string
	 */
	public function __toString() {
		$array = [];
		foreach ($this->getArrayOfStyles() as $style => $value) {
			$array[] = " $style: $value";
		}
		return implode(';', $array);
	}
	
	/**
	 * @return array
	 */
	private function getArrayOfStyles() : array {
		return $this->arrayOfStyles;
	}
	
	/**
	 * @param array $arrayOfStyles
	 */
	private function setArrayOfStyles(array $arrayOfStyles) {
		$this->arrayOfStyles = $arrayOfStyles;
	}
}

/**
 * @param array $styles
 *
 * @return Style
 */
function Style(array $styles) {
	return new Style($styles);
}
