<?php

namespace model\Entity;

use DATABASE\ORM\Interact\Entities\EntityScheme;

class AboutUsEntity extends EntityScheme
{
    public $about_us_id;
    public $title;
    public $image;
    public $description;
    public $second_title;
    public $second_image;
    public $second_description;


    public function model()
    {
        return new \model\AboutUs();
    }

    public function apiFormat()
    {
        $faq = \model\Faqs::Db()->where('faq_type','1')->get()->map(function (FaqsEntity $faq){
           return $faq->apiFormat();
        });
        $whyUs = \model\WhyUs::Db()->get()->map(function (WhyUsEntity $data){
            return $data->apiFormat();
        });
        return [
            'firstTitle' => $this->title,
            'firstText' => $this->description,
            'firstImage' => __IMAGES__ . 'AboutUs/' . $this->image,
            'faq' => $faq,
            'secondTitle' => $this->second_title,
            'secondText' => $this->second_description,
            'secondImage' => __IMAGES__ . 'AboutUs/' . $this->second_image,
            'whyUs' => $whyUs,
        ];
    }


    protected function dictionary(): array
    {
        return [
            'about_us_id' => 'about_us_id',
            'title' => 'about_us_title',
            'image' => 'about_us_image',
            'description' => 'about_us_description',
            'second_title' => 'about_us_second_title',
            'second_image' => 'about_us_second_image',
            'second_description' => 'about_us_second_description',
        ];
    }
}
