<?php

namespace model\Entity;

use DATABASE\ORM\Interact\Entities\EntityScheme;

class LicensesEntity extends EntityScheme
{
    public $license_id;
    /**
     * عنوان
     **/
    public $icon;
    /**
     * شهر
     **/
    public $link;


    public function model()
    {
        return new \model\Licenses();
    }

    public function apiFormat()
    {
        return[
          'icon' => __IMAGES__."Licenses/".$this->icon?:" ",
          'link' => $this->link?:" ",
        ];
    }


    protected function dictionary(): array
    {
        return [
            'license_id' => 'license_id',
            'icon' => 'license_icon',
            'link' => 'license_link',
        ];
    }
}
