<?php

namespace model\Entity;

use DATABASE\ORM\Interact\Entities\EntityScheme;
use FwHtml\Elements\Tags\Main\HtmlTags;
use FwHtml\Elements\Tags\Option;

class PlansEntity extends EntityScheme {
    public $plan_id;
    public $name;
    public $icon;
    public $price;
    public $duration;
    public $description;
    /**
     * @var bool|void
     */
    public $isActive = false;
    /**
     * @var int
     */
    public $expiresAt;

    public function model() {
        return new \model\Plans();
    }


    protected function dictionary(): array {
        return [
            'plan_id'     => 'plan_id',
            'name'        => 'plan_name',
            'description' => 'plan_description',
            'icon'        => 'plan_icon',
            'price'       => 'plan_price',
            'duration'    => 'plan_duration',
        ];
    }

    public function apiFormat(): array {
        return [
            'id'          => $this->plan_id,
            'name'        => $this->name,
            'description' => $this->description,
            'icon'        => __IMAGES__ . 'Plans/' . $this->icon,
            'price'       => $this->price,
            'duration'    => $this->duration,
            'isActive'    => $this->isActive,
            'expiresAt'   => (int)($this->expiresAt ?? 0),
        ];
    }

    public function buyPlanPageApiFormat(): array {
        return [
            'id'          => $this->plan_id,
            'name'        => $this->name,
            'description' => $this->description,
            'icon'        => __IMAGES__ . 'Plans/' . $this->icon,
            'price'       => $this->price,
        ];
    }


    public function toOption(): Option {
        return HtmlTags::Option()->Value($this->plan_id)->Content("{$this->name}")->Data_('duration', $this->duration);
    }
}
